/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class FilePort {
	
	static Object files_LOCK = new Object();
	static HashMap files = new HashMap();
	
	public void openFile(String filename) throws IOException {
		synchronized(files_LOCK) {
			File file = new File(filename);
			String cpath = file.getCanonicalPath();
			
			OutputStream out = (OutputStream)files.get(cpath);
			if (out == null) {
				out = new FileOutputStream(file);
				files.put(cpath,out);
			}
		}
	}
	
	public void writeToFile(String filename, String text) throws IOException {
		synchronized(files_LOCK) {
			File file = new File(filename);
			String cpath = file.getCanonicalPath();
			
			OutputStream out = (OutputStream)files.get(cpath);
			if (out != null) {
				out.write(text.getBytes());
				out.write('\r');
				out.write('\n');
			}
		}
	}
	
	public void closeFile(String filename) throws IOException {
		synchronized(files_LOCK) {
			File file = new File(filename);
			String cpath = file.getCanonicalPath();
			
			OutputStream out = (OutputStream)files.get(cpath);
			if (out != null) {
				out.close();
				files.remove(cpath);
			}
		}
	}
}