/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

import java.io.IOException;

public class DocumentWriter {

//	public static String write(Node root) throws IOException {
//		return write(root,true);
//	}	

	String file;
	
	public DocumentWriter(String file) {
		this.file = file;
	}
	
	boolean ignoreComments = false;
	
	public void setIgnoreComments(boolean b) {
		ignoreComments = b;
	}
	
	public String writeDoc(Node root, boolean human_readable) throws IOException {
		return writeDoc(root,human_readable,false);
	}
	
	public String writeNode(Node root, boolean human_readable) throws IOException {
		return writeNode(root,human_readable,false);
	}	

	public String writeDoc(Node root, boolean human_readable, boolean track_lines) throws IOException {
		StringBuffer sb = new StringBuffer(); 
		sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		write(root,sb,0,human_readable,track_lines?new LineTracker(sb):null);
		return sb.toString();
	}
	
	public String writeNode(Node root, boolean human_readable, boolean track_lines) throws IOException {
		StringBuffer sb = new StringBuffer(); 
		write(root,sb,0,human_readable,track_lines?new LineTracker(sb):null);
		return sb.toString();
	}	

	private void write(Node node, StringBuffer sb, int depth, boolean human_readable, LineTracker lt) throws IOException {

		if (lt != null) {
			node.setWrittenLine(lt.getLines());
		}

		String nodename = node.getNodeName();
		String nodevalue = node.getNodeValue();

		if (node.getNodeType() == Node.TEXT_NODE) {

			char[] tmp = nodevalue.toCharArray();
			for (int i = 0; i < tmp.length; i++) {
				if (tmp[i] == '<') {
					sb.append("&lt;");
				} else {
					sb.append(tmp[i]);
				}
			}
			
//			sb.append(nodevalue);
		
		} else if (node.getNodeType() == Node.COMMENT_NODE) {
			
			if (!ignoreComments) {
				sb.append("<!--").append(nodevalue).append("-->");
			}
			
		} else if (node.getNodeType() == Node.ELEMENT_NODE) {

			if (human_readable) {
				for (int i = 0; i < depth; i++) {
					sb.append("  ");			
				}
			}

			sb.append('<');
			sb.append(nodename);

			NamedNodeMap map = node.getAttributes();

			for (int i = 0; i < map.getLength(); i++) {
				
				Node attr = map.item(i);
				
				String name = attr.getNodeName();
				String value = attr.getNodeValue();

				if (value != null) {
	
					if (human_readable && i > 0) {
						sb.append('\n');
						int tmp = (depth*2) + nodename.length() + 1;
						for (int k = 0; k < tmp; k++) {
							sb.append(' ');			
						}
					}
	
					sb.append(" ");
					sb.append(name);
					sb.append("=\"");
	
					int strlen = value.length();
					char ch = 0;
					for (int c = 0; c < strlen; c++) {
						ch = value.charAt(c);
						if (ch == '&') {
							sb.append("&amp");
						} else if (ch == '<') {
							sb.append("&lt;");
						} else if (ch == '>') {
							sb.append("&gt;");
						} else if (ch == '"') {
							sb.append("&qt;");
						} else if (ch == '\'') {
							sb.append("&apos;");
						} else {
							sb.append(ch);
						}  
					}
	
					sb.append("\"");
				
				}
			}//end for loop

		}//end node is element

		//first child is line number comment
		
		NodeList list = node.getChildNodes();

		if (node.getNodeType() == Node.ELEMENT_NODE) {
			if (list.getLength() == 0 && lt == null) {
				sb.append(" />");
				if (human_readable) sb.append('\n');
			} else {
				sb.append(" >");

				if (lt != null) {
					boolean hasLineNumber = false;
					if (list.getLength() > 0) {
						Node n = list.item(0);
						if (n.getNodeType() == Node.COMMENT_NODE) {
							if (n.getNodeValue().trim().startsWith("LINENO ")) {
								hasLineNumber = true;
							}
						}
					}
					if (!hasLineNumber) {
						if (node.getStartLine() == -1) {
							sb.append("<!--LINENO file "+file+" line "+lt.getLines()+" -->");
						} else {
							//carry over the original start line and file
							sb.append("<!--LINENO file "+file+" line "+node.getStartLine()+" -->");
						}
					}
				}
				
				if (human_readable) sb.append('\n');
	
				for (int i = 0;  i < list.getLength(); i++) {
					Node child = list.item(i);
					write(child,sb,depth+1,human_readable,lt);
				}
	
				if (human_readable) {
					for (int i = 0; i < depth; i++) {
						sb.append("  ");			
					}
				}
	
				sb.append("</");
				sb.append(node.getNodeName());
				sb.append('>');
				if (human_readable) sb.append('\n');
			}
		} else if (node.getNodeType() == Node.DOCUMENT_NODE) {
			for (int i = 0;  i < list.getLength(); i++) {
				Node child = list.item(i);
				write(child,sb,depth,human_readable,lt);
			}
		}//end if element node
	}

	class LineTracker {
		int index = 0;
		int lines = 1;
		StringBuffer sb;
		public LineTracker(StringBuffer sb) {
			this.sb = sb;
		}
		public int getLines() {
			for (/*index=index*/; index < sb.length(); index++) {
				if (sb.charAt(index)=='\n') {
					lines++;
				}
			}
			return lines;
		}
	}
}