/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.AbstractFlowBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.activities.ActivityDiamondFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityOvalFigure;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.WrapperNodeFigureEx;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizableActivityEditPolicy;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.MessageConnectionValidator;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityEditPart
extends ShapeNodeEditPart {
    private static final int SHAPE_RECTANGLE = 0;
    private static final int SHAPE_DIAMOND = 1;
    private static final int SHAPE_CIRCLE = 2;
    public static final int EVENT_FIGURE_SIZE = 30;
    public static final int GATEWAY_FIGURE_SIZE = 50;
    public static final Dimension ACTIVITY_FIGURE_SIZE = new Dimension(111, 61);
    public static final int VISUAL_ID = 2001;
    private int handlePosition;
    protected boolean isChildAdded = false;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private NodeFigure wrappedFigure;

    public ActivityEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ActivityCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new ConnectionHandleEditPolicyEx());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = ActivityEditPart.this.getPrimaryDragEditPolicy();
                    if (result != null) {
                        return result;
                    }
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected IFigure createNodeShapeGen() {
        ActivityFigure figure = new ActivityFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    protected IFigure createNodeShape() {
        ActivityFigure figure = (ActivityFigure)this.createNodeShapeGen();
        Activity activity = (Activity)this.getPrimaryView().getElement();
        this.setActivityTypeAndLabelAndLayout(figure, activity);
        figure.setLooping(activity.isLooping());
        return figure;
    }

    private boolean setActivityTypeAndLabelAndLayout(ActivityFigure activityFigure, Activity activity) {
        StackLayout layout;
        activityFigure.setActivityType(activity.getActivityType().getName());
        boolean res = false;
        if (activity.getName() == null) {
            WrapLabel wl = activityFigure.getFigureActivityNameFigure();
            if (activity.getActivityType().equals(ActivityType.TASK_LITERAL)) {
                wl.setTextWrap(true);
                if (!"Task".equals(wl.getText())) {
                    wl.setText("Task");
                }
            }
            res = true;
        }
        if (activity.getActivityType().equals(ActivityType.TASK_LITERAL)) {
            if (!(activityFigure.getLayoutManager() instanceof StackLayout)) {
                layout = new StackLayout();
                activityFigure.setLayoutManager((LayoutManager)layout);
                res = true;
            }
        } else if (!(activityFigure.getLayoutManager() instanceof ConstrainedToolbarLayout)) {
            layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            activityFigure.setLayoutManager((LayoutManager)layout);
            res = true;
        }
        return res;
    }

    public ActivityFigure getPrimaryShape() {
        return (ActivityFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityNameEditPart) {
            ((ActivityNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureActivityNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected NodeFigure createNodePlate() {
        return new WrapperNodeFigureEx(ConnectionAnchorFactory.INSTANCE, this.createWrappedFigure()){

            public Rectangle getHandleBounds() {
                Rectangle rectangle = super.getHandleBounds();
                Activity activity = (Activity)ActivityEditPart.this.resolveSemanticElement();
                if (activity == null || activity.getActivityType() == null || activity.getActivityType().equals(ActivityType.TASK_LITERAL)) {
                    return rectangle;
                }
                IGraphicalEditPart activityNameEditPart = ActivityEditPart.this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001));
                int nameFigureHeight = activityNameEditPart == null || activityNameEditPart.getFigure() == null ? 0 : activityNameEditPart.getFigure().getSize().height;
                return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height - nameFigureHeight);
            }

            public void setBounds(Rectangle rect) {
                boolean translate;
                int x = this.bounds.x;
                int y = this.bounds.y;
                boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
                boolean bl = translate = rect.x != x || rect.y != y;
                if ((resize || translate) && this.isVisible()) {
                    this.erase();
                }
                if (translate) {
                    int dx = rect.x - x;
                    int dy = rect.y - y;
                    this.primTranslate(dx, dy);
                }
                this.bounds.width = rect.width;
                this.bounds.height = rect.height;
                if (translate || resize) {
                    if (resize || ActivityEditPart.this.isChildAdded && translate) {
                        this.invalidate();
                    }
                    this.fireFigureMoved();
                    this.repaint();
                }
            }
        };
    }

    private NodeFigure createWrappedFigure() {
        Activity activity = (Activity)this.getPrimaryView().getElement();
        int activityType = activity.getActivityType().getValue();
        int shapeType = ActivityEditPart.getShapeType(activityType);
        if (shapeType == 0) {
            int width = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.width);
            int height = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.height);
            this.wrappedFigure = new ActivityNodeFigure(width, height);
        } else if (shapeType == 1) {
            int width = this.getMapMode().DPtoLP(50);
            int height = this.getMapMode().DPtoLP(50);
            this.wrappedFigure = new ActivityNodeFigure(width, height);
        } else {
            int width = this.getMapMode().DPtoLP(30);
            int height = this.getMapMode().DPtoLP(30);
            this.wrappedFigure = new ActivityNodeFigure(width, height);
        }
        this.wrappedFigure.setLayoutManager((LayoutManager)new StackLayout());
        return this.wrappedFigure;
    }

    private void buildFigure(IFigure container, IFigure shape, WrapLabel wrapLabel, int size) {
        int resultSize = this.getMapMode().DPtoLP(size);
        container.setSize(resultSize, resultSize);
        this.wrappedFigure.setLayoutManager((LayoutManager)new BorderLayout());
        container.setLayoutManager((LayoutManager)new StackLayout());
        container.add(shape);
        this.wrappedFigure.add(container, (Object)BorderLayout.CENTER);
        this.wrappedFigure.add((IFigure)wrapLabel, (Object)BorderLayout.BOTTOM);
        wrapLabel.setTextWrap(true);
        wrapLabel.setLabelAlignment(2);
        ((ActivityFigure)shape).setFigureActivityNameFigure(wrapLabel);
        this.contentPane = this.setupContentPane((IFigure)this.wrappedFigure);
    }

    protected NodeFigure createNodeFigure() {
        boolean event;
        NodeFigure figure = this.createNodePlate();
        IFigure shape = this.createNodeShape();
        ActivityType activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        if (gateway) {
            int size = this.getMapMode().DPtoLP(50);
            ActivityDiamondFigure diamondFigure = new ActivityDiamondFigure(new Dimension(size, size));
            WrapLabel label = new WrapLabel();
            this.buildFigure((IFigure)diamondFigure, shape, label, 50);
        } else if (event) {
            ActivityOvalFigure ovalFigure = new ActivityOvalFigure();
            WrapLabel label = new WrapLabel();
            this.buildFigure((IFigure)ovalFigure, shape, label, 30);
        } else {
            this.wrappedFigure.add(shape);
            this.contentPane = this.setupContentPane(shape);
        }
        return figure;
    }

    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            EObject element = ((Node)this.getModel()).getElement();
            int activityType = ((Activity)element).getActivityType().getValue();
            if (activityType == 0) {
                StackLayout layout = new StackLayout();
                nodeShape.setLayoutManager((LayoutManager)layout);
            } else {
                return this.setupContentPaneGen(nodeShape);
            }
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    private boolean isEventOrGateway() {
        boolean event;
        ActivityType activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        return gateway || event;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1) {
            if (BpmnPackage.eINSTANCE.getActivity_ActivityType().equals(notification.getFeature())) {
                ActivityType cfr_ignored_0 = (ActivityType)notification.getOldValue();
                ActivityType cfr_ignored_1 = (ActivityType)notification.getNewValue();
                this.handleMajorSemanticChange();
                return;
            }
            if (BpmnPackage.eINSTANCE.getActivity_Looping().equals(notification.getFeature())) {
                this.getPrimaryShape().setLooping(notification.getNewBooleanValue());
            } else if (NotationPackage.eINSTANCE.getSize_Width().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getSize_Height().equals(notification.getFeature())) {
                this.setChildAdded(true);
            } else if (BpmnPackage.eINSTANCE.getNamedBpmnObject_Name().equals(notification.getFeature())) {
                this.isEventOrGateway();
            }
            Activity activity = (Activity)this.getPrimaryView().getElement();
            if (this.setActivityTypeAndLabelAndLayout(this.getPrimaryShape(), activity)) {
                this.refreshVisuals();
            }
        }
        super.handleNotificationEvent(notification);
    }

    public void refreshSourceConnections() {
        super.refreshSourceConnections();
        this.updateAnchors(true);
    }

    public void refreshTargetConnections() {
        super.refreshTargetConnections();
        this.updateAnchors(false);
    }

    private void updateAnchors(boolean sourceOnly) {
        View model;
        ConnectionEditPart connEditPart;
        HashMap<EObject, ConnectionEditPart> connIndex = new HashMap<EObject, ConnectionEditPart>();
        for (Object object : this.getSourceConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        for (Object object : this.getTargetConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        FeatureMap messages = ((Activity)((Node)this.getModel()).getElement()).getOrderedMessages();
        int totalLength = messages.size();
        int i = 0;
        for (FeatureMap.Entry msg : messages) {
            switch (msg.getEStructuralFeature().getFeatureID()) {
                case 11: {
                    this.setAnchorIndex(connIndex, (EObject)msg.getValue(), i, totalLength, true, String.valueOf(3002));
                    ++i;
                    break;
                }
                case 10: {
                    this.setAnchorIndex(connIndex, (EObject)msg.getValue(), i, totalLength, false, String.valueOf(3002));
                    ++i;
                    break;
                }
                default: {
                    throw new IllegalStateException("Corrupted model?");
                }
            }
        }
        if (sourceOnly) {
            EList outEdges = ((Activity)((Node)this.getModel()).getElement()).getOutgoingEdges();
            int ind = 0;
            totalLength = outEdges.size();
            for (Object edge : outEdges) {
                this.setAnchorIndex(connIndex, (EObject)edge, i, totalLength, true, String.valueOf(3001));
                ++ind;
            }
        } else {
            EList inEdges = ((Activity)((Node)this.getModel()).getElement()).getIncomingEdges();
            int ind = 0;
            totalLength = inEdges.size();
            for (Object edge : inEdges) {
                this.setAnchorIndex(connIndex, (EObject)edge, i, totalLength, false, String.valueOf(3001));
                ++ind;
            }
        }
    }

    private void setAnchorIndex(Map<EObject, ConnectionEditPart> connIndex, EObject msgOrSequence, int index, int totalLength, boolean isSource, String edgeType) {
        ConnectionEditPart conn = connIndex.get(msgOrSequence);
        if (conn == null) {
            System.err.println("Could not find a ConnectionEditPart for " + msgOrSequence);
        } else {
            ConnectionAnchor anchor;
            PolylineConnectionEx connFigure = (PolylineConnectionEx)conn.getFigure();
            ConnectionAnchor connectionAnchor = anchor = isSource ? connFigure.getSourceAnchor() : connFigure.getTargetAnchor();
            if (anchor instanceof IModelAwareAnchor) {
                ((IModelAwareAnchor)anchor).setConnectionType(isSource, edgeType, index, totalLength);
                conn.refresh();
            }
        }
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableActivityEditPolicy();
    }

    private static int getShapeType(int activityType) {
        int shapeType;
        switch (activityType) {
            case 0: {
                shapeType = 0;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                shapeType = 1;
                break;
            }
            default: {
                shapeType = 2;
            }
        }
        return shapeType;
    }

    public Command getCommand(Request _request) {
        Object model;
        if (_request instanceof CreateUnspecifiedTypeConnectionRequest && (model = ((CreateUnspecifiedTypeConnectionRequest)_request).getTargetEditPart().getModel()) instanceof Node) {
            List elTypes = ((CreateUnspecifiedTypeConnectionRequest)_request).getElementTypes();
            MetamodelType connType = (MetamodelType)BpmnElementTypes.MessagingEdge_3002;
            int i = 0;
            while (i < elTypes.size()) {
                if (elTypes.get(i) instanceof MetamodelType) {
                    connType = (MetamodelType)elTypes.get(i);
                    break;
                }
                ++i;
            }
            if (connType == BpmnElementTypes.MessagingEdge_3002) {
                CreateUnspecifiedTypeConnectionRequest request;
                MessageConnectionValidator messageValidator = new MessageConnectionValidator();
                if (_request instanceof CreateUnspecifiedTypeConnectionRequest && !(request = (CreateUnspecifiedTypeConnectionRequest)_request).isDirectionReversed()) {
                    if (request.getSourceEditPart() != null && request.getTargetEditPart() != null) {
                        for (CreateConnectionRequest connectionRequest : request.getAllRequests()) {
                            if (!(connectionRequest.getSourceEditPart() != null && connectionRequest.getTargetEditPart() != null && connectionRequest.getSourceEditPart() == request.getSourceEditPart() && connectionRequest.getTargetEditPart() == request.getTargetEditPart() ? !messageValidator.canConnect(request.getSourceEditPart(), request.getTargetEditPart()) : !messageValidator.canConnect(request.getTargetEditPart(), request.getSourceEditPart()))) continue;
                            return null;
                        }
                    }
                    if (request.getSourceEditPart() == null && request.getTargetEditPart() != null && !messageValidator.canStart(request.getTargetEditPart())) {
                        return null;
                    }
                }
            } else if (connType == BpmnElementTypes.SequenceEdge_3001) {
                CreateUnspecifiedTypeConnectionRequest request;
                EdgeConnectionValidator edgeValidator = new EdgeConnectionValidator();
                if (_request instanceof CreateConnectionRequest) {
                    CreateConnectionRequest connectionRequest = (CreateConnectionRequest)_request;
                    if (connectionRequest.getTargetEditPart() == null || connectionRequest.getSourceEditPart() == null) {
                        return super.getCommand(_request);
                    }
                    if (connectionRequest.getSourceEditPart() != null && connectionRequest.getTargetEditPart() != null && connectionRequest.getSourceEditPart() == connectionRequest.getSourceEditPart() && connectionRequest.getTargetEditPart() == connectionRequest.getTargetEditPart() ? !edgeValidator.canConnect(connectionRequest.getSourceEditPart(), connectionRequest.getTargetEditPart()) : !edgeValidator.canConnect(connectionRequest.getTargetEditPart(), connectionRequest.getSourceEditPart())) {
                        return null;
                    }
                }
                if (_request instanceof CreateUnspecifiedTypeConnectionRequest && !(request = (CreateUnspecifiedTypeConnectionRequest)_request).isDirectionReversed()) {
                    if (request.getSourceEditPart() != null && request.getTargetEditPart() != null) {
                        if (request.getSourceEditPart().equals(request.getTargetEditPart())) {
                            return null;
                        }
                        for (CreateConnectionRequest connectionRequest : request.getAllRequests()) {
                            if (!(connectionRequest.getSourceEditPart() != null && connectionRequest.getTargetEditPart() != null && connectionRequest.getSourceEditPart() == request.getSourceEditPart() && connectionRequest.getTargetEditPart() == request.getTargetEditPart() ? !edgeValidator.canConnect(request.getSourceEditPart(), request.getTargetEditPart()) : !edgeValidator.canConnect(request.getTargetEditPart(), request.getSourceEditPart()))) continue;
                            return null;
                        }
                    }
                    if (request.getSourceEditPart() == null && request.getTargetEditPart() != null && !edgeValidator.canStart(request.getTargetEditPart())) {
                        return null;
                    }
                }
            }
        }
        return super.getCommand(_request);
    }

    public boolean isChildAdded() {
        return this.isChildAdded;
    }

    public void setChildAdded(boolean isChildAdded) {
        this.isChildAdded = isChildAdded;
    }

    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx((EditPart)this);
    }

    public int getHandlePosition() {
        return this.handlePosition;
    }

    public void setHandlePosition(int handlePosition) {
        this.handlePosition = handlePosition;
    }

    public class ActivityFigure
    extends org.eclipse.stp.bpmn.figures.activities.ActivityFigure {
        private WrapLabel fActivityNameFigure;
        private boolean myUseLocalCoordinates = false;

        public ActivityFigure() {
            this.setActivityType(((Activity)ActivityEditPart.this.resolveSemanticElement()).getActivityType().getName());
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
        }

        private void createContents() {
            ActivityType activityType = ((Activity)ActivityEditPart.this.getPrimaryView().getElement()).getActivityType();
            if (activityType.equals(ActivityType.TASK_LITERAL)) {
                this.createContentsGen();
            }
        }

        private void createContentsGen() {
            WrapLabel fig_0 = new WrapLabel();
            fig_0.setTextWrap(true);
            fig_0.setText("Task");
            this.setBorder((Border)new AbstractFlowBorder(){

                public int getLeftMargin() {
                    return 2;
                }

                public int getRightMargin() {
                    return 2;
                }

                public Insets getInsets(IFigure figure) {
                    return new Insets(0, 2, 0, 2);
                }
            });
            this.setFigureActivityNameFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        public WrapLabel getFigureActivityNameFigure() {
            return this.fActivityNameFigure;
        }

        private void setFigureActivityNameFigure(WrapLabel fig) {
            this.fActivityNameFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

