/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

public class BpmnDiagramXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public static final int DEFAULT_POOL_X_COORD = 16;

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        int maxWidth = 200;
        HashMap<Rectangle, IGraphicalEditPart> toSortBounds = new HashMap<Rectangle, IGraphicalEditPart>();
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart childPart = (IGraphicalEditPart)child;
            Rectangle rect = childPart.getFigure().getBounds().getCopy();
            if (request.getEditParts().contains(child)) {
                if (request.getSizeDelta() != null) {
                    rect.width += request.getSizeDelta().width;
                    rect.height += request.getSizeDelta().height;
                }
                if (request.getMoveDelta() != null) {
                    rect.y += request.getMoveDelta().y;
                    rect.x += request.getMoveDelta().x;
                }
            }
            maxWidth = maxWidth < rect.width ? rect.width : maxWidth;
            toSortBounds.put(rect, childPart);
        }
        LinkedList keys = new LinkedList(toSortBounds.keySet());
        Collections.sort(keys, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle o1, Rectangle o2) {
                if (o1.y <= o2.y) {
                    return -1;
                }
                return 1;
            }
        });
        int y = 0;
        CompoundCommand command = new CompoundCommand("Resizing pools");
        for (Rectangle key : keys) {
            IGraphicalEditPart part = (IGraphicalEditPart)toSortBounds.get(key);
            key.y = y = key.y < y + 16 ? y + 16 : key.y;
            if (part instanceof PoolEditPart) {
                key.x = 16;
                key.width = maxWidth;
            }
            command.add(this.createChangeConstraintCommand((EditPart)part, key));
            y += key.height;
        }
        return command;
    }

    protected Object getConstraintFor(CreateRequest request) {
        Object constraint = super.getConstraintFor(request);
        if (request == null || request.getNewObject() == null || ((List)request.getNewObject()).isEmpty() || ((List)request.getNewObject()).get(0) == null || ((CreateViewRequest.ViewDescriptor)((List)request.getNewObject()).get(0)).getElementAdapter() == null || ((List)request.getNewObject()).get(0) == null) {
            return constraint;
        }
        IElementType type = (IElementType)((CreateViewRequest.ViewDescriptor)((List)request.getNewObject()).get(0)).getElementAdapter().getAdapter(IElementType.class);
        int maxWidth = 200;
        if (((BpmnDiagram)((IGraphicalEditPart)this.getHost()).resolveSemanticElement()).getPools().isEmpty()) {
            maxWidth = 1500;
        }
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart childPart = (IGraphicalEditPart)child;
            Rectangle rect = childPart.getFigure().getBounds().getCopy();
            int n = maxWidth = maxWidth < rect.width ? rect.width : maxWidth;
        }
        if (type == BpmnElementTypes.Pool_1001) {
            ((Rectangle)constraint).x = 16;
            ((Rectangle)constraint).width = maxWidth;
            ((Rectangle)constraint).height = 200;
            return constraint;
        }
        return constraint;
    }

    protected Command getCreateCommand(CreateRequest request) {
        CompoundCommand co = new CompoundCommand();
        co.add(super.getCreateCommand(request));
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        Rectangle addedThing = (Rectangle)this.getConstraintFor(request);
        List children = ((IGraphicalEditPart)this.getHost()).getChildren();
        LinkedList<IGraphicalEditPart> parts = new LinkedList<IGraphicalEditPart>();
        Point location = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)location);
        for (Object child : children) {
            Rectangle rect = ((IGraphicalEditPart)child).getFigure().getBounds();
            if (rect.y <= location.y) continue;
            parts.add((IGraphicalEditPart)child);
        }
        if (!parts.isEmpty()) {
            req.setEditParts(parts);
            req.setConstrainedMove(true);
            req.setMoveDelta(new Point(addedThing.x, ((Rectangle)this.getConstraintFor((CreateRequest)request)).height + 16));
            co.add(this.getResizeChildrenCommand(req));
        }
        return co;
    }
}

