/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcessSubProcessCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private static final Dimension MIN_DIMENSION = SubProcessEditPart.EXPANDED_SIZE.getCopy();
    public static final Insets INSETS = SubProcessEditPart.INSETS;

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        List<Request> requests = this.chunkNegativeMove(request);
        CompoundCommand command = new CompoundCommand();
        command.add(super.getResizeChildrenCommand(request));
        if (requests != null && !requests.isEmpty()) {
            for (Request negativeReq : requests) {
                Command co = this.getHost().getParent().getParent().getCommand(negativeReq);
                command.add(co);
            }
        } else {
            ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
            req.setEditParts(this.getHost().getParent());
            req.setCenteredResize(true);
            req.setSizeDelta(this.getMinSizeForSP(request));
            command.add(this.getHost().getParent().getParent().getCommand((Request)req));
        }
        return command;
    }

    private List<Request> chunkNegativeMove(ChangeBoundsRequest request) {
        if (request == null) {
            return null;
        }
        boolean isNegative = false;
        Point maxMove = new Point(request.getMoveDelta().x, request.getMoveDelta().y);
        for (Object ep : request.getEditParts()) {
            int ymove;
            Point loc = ((GraphicalEditPart)ep).getFigure().getBounds().getLocation().getCopy();
            int xmove = loc.x + request.getMoveDelta().x - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.left;
            if (xmove <= 0) {
                maxMove.x = -loc.x + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.left;
                isNegative = true;
            }
            if ((ymove = loc.y + request.getMoveDelta().y - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.top) > 0) continue;
            maxMove.y = -loc.y + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.top;
            isNegative = true;
        }
        Point p = new Point(request.getMoveDelta().x - maxMove.x, request.getMoveDelta().y - maxMove.y);
        request.setMoveDelta(maxMove);
        if (isNegative) {
            int toobigy = request.getMoveDelta().y + request.getSizeDelta().height;
            int maxHeight = 0;
            for (Object ep : request.getEditParts()) {
                maxHeight = Math.max(maxHeight, ((GraphicalEditPart)ep).getFigure().getBounds().height + ((GraphicalEditPart)ep).getFigure().getBounds().y);
            }
            if (this.getHostFigure().getBounds().height < toobigy + maxHeight) {
                isNegative = false;
            }
        }
        if (isNegative) {
            int toobigx = request.getMoveDelta().x + request.getSizeDelta().width;
            int maxWidth = 0;
            for (Object ep : request.getEditParts()) {
                maxWidth = Math.max(maxWidth, ((GraphicalEditPart)ep).getFigure().getBounds().width + ((GraphicalEditPart)ep).getFigure().getBounds().x);
            }
            if (this.getHostFigure().getBounds().width < toobigx + maxWidth) {
                isNegative = false;
            }
        }
        if (!isNegative) {
            return null;
        }
        ChangeBoundsRequest compartmentRequest = new ChangeBoundsRequest((Object)"resize children");
        Dimension d = new Dimension(Math.abs(p.x), Math.abs(p.y));
        compartmentRequest.setMoveDelta(p);
        compartmentRequest.setSizeDelta(d);
        compartmentRequest.setEditParts(this.getHost().getParent());
        ChangeBoundsRequest childrenRequest = new ChangeBoundsRequest((Object)"resize children");
        Point childrenMove = new Point(-p.x, -p.y);
        childrenRequest.setMoveDelta(childrenMove);
        childrenRequest.setEditParts(new LinkedList(this.getHost().getChildren()));
        childrenRequest.getEditParts().removeAll(request.getEditParts());
        LinkedList<Request> requests = new LinkedList<Request>();
        requests.add((Request)compartmentRequest);
        if (!childrenRequest.getEditParts().isEmpty()) {
            requests.add((Request)childrenRequest);
        }
        return requests;
    }

    private Dimension getMinSizeForSP(CreateRequest request) {
        Dimension requestSize;
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(Collections.EMPTY_LIST);
        Dimension dim = this.getMinSizeForSP(req);
        Dimension dimension = requestSize = request.getSize() == null ? null : request.getSize().getCopy();
        if (requestSize == null || requestSize.width == -1 && requestSize.height == -1) {
            List descriptors;
            requestSize = new Dimension(150, 100);
            if (request instanceof CreateViewRequest && !(descriptors = ((CreateViewRequest)request).getViewDescriptors()).isEmpty()) {
                CreateViewRequest.ViewDescriptor desc = (CreateViewRequest.ViewDescriptor)descriptors.get(0);
                IElementType type = (IElementType)desc.getElementAdapter().getAdapter(IElementType.class);
                requestSize = BpmnShapesDefaultSizes.getDefaultSize(type).getCopy();
            }
        }
        Dimension initialdim = ((GraphicalEditPart)this.getHost()).getFigure().getSize().getCopy();
        if (initialdim.height == 0 && initialdim.width == 0) {
            return initialdim;
        }
        Point loc = request.getLocation().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)loc);
        this.getHostFigure().translateToRelative((Translatable)loc);
        Rectangle rect = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        loc.x -= rect.x;
        loc.y -= rect.y;
        dim.width = Math.max(dim.width, loc.x + requestSize.width + INSETS.getWidth());
        dim.height = Math.max(dim.height, loc.y + requestSize.height + INSETS.getHeight());
        dim.width = dim.width - initialdim.width + INSETS.getWidth();
        dim.height = dim.height - initialdim.height + INSETS.getHeight();
        if (dim.width < 0) {
            dim.width = 0;
        }
        if (dim.height < 0) {
            dim.height = 0;
        }
        return dim;
    }

    private Dimension getMinSizeForSP(ChangeBoundsRequest request) {
        Dimension initialdim = ((GraphicalEditPart)this.getHost()).getFigure().getSize().getCopy();
        Dimension dim = MIN_DIMENSION.getCopy();
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart part = (IGraphicalEditPart)child;
            Rectangle r = part.getFigure().getBounds().getCopy();
            int w = r.x + r.width;
            if (request.getEditParts().contains(part)) {
                w += request.getSizeDelta().width + request.getMoveDelta().x;
            }
            if (dim.width < w) {
                dim.width = w;
            }
            int h = r.y + r.height;
            if (request.getEditParts().contains(part)) {
                h += request.getSizeDelta().height + request.getMoveDelta().y;
            }
            if (dim.height >= h) continue;
            dim.height = h;
        }
        dim.width = dim.width - initialdim.width + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.left + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.right;
        dim.height = dim.height - initialdim.height + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.bottom + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.top;
        if (dim.width < 0) {
            dim.width = 0;
        }
        if (dim.height < 0) {
            dim.height = 0;
        }
        return dim;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Point loc = request.getLocation().getCopy();
        Point here = this.getHostFigure().getParent().getBounds().getCopy().getLocation();
        if (here.x != 0 || here.y != 0) {
            int correction;
            this.getHostFigure().getParent().translateToAbsolute((Translatable)here);
            this.getHostFigure().translateToAbsolute((Translatable)loc);
            this.getHostFigure().translateToRelative((Translatable)loc);
            loc.x = loc.x - here.x - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.left;
            loc.y = loc.y - here.y - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.top;
            if (loc.x <= 0) {
                correction = -loc.x + 1;
                request.getLocation().x += correction;
            }
            if (loc.y <= 0) {
                correction = -loc.y + 1;
                request.getLocation().y += correction;
            }
        }
        CompoundCommand command = new CompoundCommand();
        command.add(super.getCreateCommand(request));
        ChangeBoundsRequest thisSizeReq = new ChangeBoundsRequest((Object)"resize children");
        thisSizeReq.setCenteredResize(true);
        thisSizeReq.setEditParts(this.getHost().getParent());
        thisSizeReq.setSizeDelta(this.getMinSizeForSP(request));
        if (thisSizeReq.getSizeDelta().height == 0 && thisSizeReq.getSizeDelta().width == 0) {
            return command;
        }
        Command co = this.getHost().getParent().getParent().getCommand((Request)thisSizeReq);
        command.add(co);
        return command;
    }
}

