/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.Vertex;

public class TaskDragEditPartsTrackerEx
extends DragEditPartsTrackerEx {
    public TaskDragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    private boolean isReparentEnabled() {
        if (this.getTargetEditPart() == null) {
            return false;
        }
        IGraphicalEditPart source = (IGraphicalEditPart)this.getSourceEditPart();
        if (source.resolveSemanticElement() instanceof Activity) {
            Activity a = (Activity)source.resolveSemanticElement();
            if (!a.getIncomingEdges().isEmpty() || !a.getOutgoingEdges().isEmpty()) {
                return false;
            }
            Pool targetPool = this.getPool(((IGraphicalEditPart)this.getTargetEditPart()).resolveSemanticElement());
            if (targetPool == null) {
                return false;
            }
            for (Object msg : a.getOutgoingMessages()) {
                Activity target = ((MessagingEdge)msg).getTarget();
                if (!targetPool.equals(this.getPool(target))) continue;
                return false;
            }
            for (Object msg : a.getIncomingMessages()) {
                Activity src = ((MessagingEdge)msg).getSource();
                if (!targetPool.equals(this.getPool(src))) continue;
                return false;
            }
        } else if (source.resolveSemanticElement() instanceof Artifact) {
            return this.getTargetEditPart() != this.getSourceEditPart().getParent() && this.getTargetEditPart() != null;
        }
        return this.getCurrentInput().isShiftKeyDown();
    }

    private Pool getPool(Object elt) {
        if (elt instanceof Pool) {
            return (Pool)elt;
        }
        if (elt instanceof Activity && ((Activity)elt).getEventHandlerFor() != null) {
            return this.getPool(((Activity)elt).getEventHandlerFor());
        }
        if (elt instanceof Vertex) {
            return this.getPool(((Vertex)elt).getGraph());
        }
        return null;
    }

    protected boolean isMove() {
        boolean isMove = !this.isReparentEnabled();
        return isMove;
    }

    protected boolean isCloneActive() {
        return false;
    }

    protected Command getCommand() {
        if (this.isReparentEnabled()) {
            Request request = this.getTargetRequest();
            if (this.getTargetEditPart() != null) {
                request.setType((Object)"add children");
                Command command = this.getTargetEditPart().getCommand(request);
                return command;
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand();
    }
}

