package org.eclipse.stp.bpmn.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class TextAnnotationFigure extends DefaultSizeNodeFigure {
    
    /**
     * Constructor
     * 
     * @param width <code>int</code> value that is the default width in logical units
     * @param height <code>int</code> value that is the default height in logical units
     * @param insets <code>Insets</code> that is the empty margin inside the note figure in logical units
     */
    public TextAnnotationFigure(int width, int height, Insets insets) {
        super(width, height);
        setBorder(
            new MarginBorder(insets.top, insets.left, insets.bottom, insets.right));

        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
        layout.setMinorAlignment(ConstrainedToolbarLayout.ALIGN_TOPLEFT);
        layout.setSpacing(insets.top);
        setLayoutManager(layout);
    }
    
    protected void paintFigure(Graphics graphics) {
        int lineWidth = MapModeUtil.getMapMode(this).LPtoDP(1);
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setLineWidth(lineWidth);
        Rectangle rect = getBounds().getCopy();
        rect.height--;
        rect.width = Math.min(rect.width, MapModeUtil.getMapMode(this).LPtoDP(30));
        PointList pl = new PointList();
        pl.addPoint(rect.getTop());
        pl.addPoint(rect.getTopLeft());
        pl.addPoint(rect.getBottomLeft());
        pl.addPoint(rect.getBottom());
        graphics.drawPolyline(pl);
    }

    /**
     * @see org.eclipse.draw2d.IFigure#getPreferredSize(int, int)
     */
    public Dimension getPreferredSize(int wHint, int hHint) {
        return super.getPreferredSize(wHint, hHint).getUnioned(new Dimension(
                                MapModeUtil.getMapMode(this).DPtoLP(50), 
                                MapModeUtil.getMapMode(this).DPtoLP(30)));
    }

}