/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.core.resources.IProject;

/**
 * The IResourceAssistantFactory can be installed via the
 * IEMFWorkbenchContextFactory, in order to provide an on-demand hook whenver a
 * new IEMFWorkbenchContext is created.
 * 
 * <p>
 * Every installed Resource Assistant Factory will be consulted for each
 * IEMFWorkbenchContext that is created. A factory should only create
 * IResourceAssistants for interesting projects.
 * </p>
 * 
 * @see org.eclipse.stp.core.infrastructure.emf.IResourceAssistant
 */
public interface IResourceAssistantFactory {

   IResourceAssistant createResourceAssistant(IProject aProject);

}
