/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface ICompositeCreationDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [OPTIONAL] Name of the Composite. If not specified default value will be
    * used. Default value is set to PROJECT_NAME
    * 
    * Type = {@link String} Defaulted to the name of the Project
    */
   public static final String NAME      = "ICompositeCreationDataModelProperties.NAME";     //$NON-NLS-1$

   /**
    * [OPTIONAL] Property indicating the Container into which the composite file
    * will be generated. This container must be a valid IContainer.
    * 
    * Type = {@link org.eclipse.core.resources.IContainer} Defaulted to the
    * Project
    */
   public static final String CONTAINER = "ICompositeCreationDataModelProperties.CONTAINER"; //$NON-NLS-1$
}
