/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.introspection;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.core.sca.Implementation;

/**
 * The IShareableComponentTypeFactory must be able to accept a custom
 * Implementation representing a custom feature and convert the Implementation
 * to a URI. The URI will then be used to request a shared resource.
 * 
 * <p>
 * Clients should refer to <b>com.ibm.ccl.soa.core.componentTypeIntrospector</b>
 * for more information on when to use interface.
 * </p>
 * 
 * <p>
 * Clients may implement this interface.
 * </p>
 * 
 * @since 1.0
 * 
 */
public interface IShareableComponentTypeFactory {

   /**
    * This method should return an IFile for the shareable resource. that can be
    * used to load a shared Resource that will contain a ComponentType.
    * 
    * The structural feature can be passed to
    * ExtendedMetadata.INSTANCE.getName() to determine the XML element used to
    * serialize the associated model object.
    * 
    * 
    * @param theImplementationFeature
    *           The EMF feature (substitution group) context for the given
    *           implementation
    * @param anImplementation
    *           The implementation with metadata about the ComponentType
    * @return A URI that can be used to request the componentType as a resource
    *         from a ResourceSet
    */
   IFile findShareableFile(EStructuralFeature theImplementationFeature,
         Implementation anImplementation);

}
