/**
 * <copyright> </copyright>
 * 
 * $Id: ComponentImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.ComponentWireHandle;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Component</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentImpl#getPropertyValuesSet <em>Property Values Set</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentImpl#getReferenceValuesSet <em>Reference Values Set</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public abstract class ComponentImpl extends SCAInternalObjectImpl implements
      Component {

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright          = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getPropertyValuesSet() <em>Property Values Set</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getPropertyValuesSet()
    * @generated
    * @ordered
    */
   protected PropertyValuesSet   propertyValuesSet  = null;

   /**
    * The cached value of the '{@link #getReferenceValuesSet() <em>Reference Values Set</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getReferenceValuesSet()
    * @generated
    * @ordered
    */
   protected ReferenceValuesSet  referenceValuesSet = null;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String NAME_EDEFAULT      = null;

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String              name               = NAME_EDEFAULT;

   /* **************** Custom fields ************** */

   private static final String   EMPTY_STRING       = "";                                                                                                   //$NON-NLS-1$ 

   // private ReferenceValuesListDelegate referenceValuesDelegate;

   private Map                   sourceWireHandles;

   private Map                   targetWireHandles;

   private static class ReferenceValuesListDelegate implements List {

      private ComponentImpl      component;

      private ReferenceValuesSet set;

      private ReferenceValuesListDelegate(ComponentImpl component) {
         this.component = component;
         this.set = component.getReferenceValuesSet();
      }

      private void initializeReferenceValuesSet() {
         set = SCAFactory.eINSTANCE.createReferenceValuesSet();
         component.setReferenceValuesSet(set);
      }

      public int size() {
         return set == null ? 0 : set.getReferenceValues().size();
      }

      public boolean isEmpty() {
         return set == null ? true : set.getReferenceValues().isEmpty();
      }

      public boolean contains(Object o) {
         return set == null ? false : set.getReferenceValues().contains(o);
      }

      public Iterator iterator() {
         return set == null ? null : set.getReferenceValues().iterator();
      }

      public Object[] toArray() {
         return set == null ? new Object[0] : set.getReferenceValues()
               .toArray();
      }

      public Object[] toArray(Object[] a) {
         return set == null ? new Object[0] : set.getReferenceValues().toArray(
               a);
      }

      public boolean add(Object o) {
         if (set == null)
            initializeReferenceValuesSet();
         return set.getReferenceValues().add(o);
      }

      public boolean remove(Object o) {
         return set == null ? false : set.getReferenceValues().remove(o);
      }

      public boolean containsAll(Collection c) {
         return set == null ? false : set.getReferenceValues().containsAll(c);
      }

      public boolean addAll(Collection c) {
         if (set == null)
            initializeReferenceValuesSet();
         return set.getReferenceValues().addAll(c);
      }

      public boolean addAll(int index, Collection c) {
         if (set == null)
            initializeReferenceValuesSet();
         return set.getReferenceValues().addAll(index, c);
      }

      public boolean removeAll(Collection c) {
         return set == null ? false : set.getReferenceValues().removeAll(c);
      }

      public boolean retainAll(Collection c) {
         return set == null ? false : set.getReferenceValues().retainAll(c);
      }

      public void clear() {
         if (set != null)
            set.getReferenceValues().clear();
      }

      public Object get(int index) {
         return set == null ? null : set.getReferenceValues().get(index);
      }

      public Object set(int index, Object element) {
         return set == null ? null : set.getReferenceValues().set(index,
               element);
      }

      public void add(int index, Object element) {
         if (set == null)
            initializeReferenceValuesSet();
         set.getReferenceValues().add(index, element);
      }

      public Object remove(int index) {
         return set == null ? null : set.getReferenceValues().remove(index);
      }

      public int indexOf(Object o) {
         return set == null ? -1 : set.getReferenceValues().indexOf(o);
      }

      public int lastIndexOf(Object o) {
         return set == null ? -1 : set.getReferenceValues().lastIndexOf(o);
      }

      public ListIterator listIterator() {
         return set == null ? null : set.getReferenceValues().listIterator();
      }

      public ListIterator listIterator(int index) {
         return set == null ? null : set.getReferenceValues().listIterator(
               index);
      }

      public List subList(int fromIndex, int toIndex) {
         return set == null ? Collections.EMPTY_LIST : set.getReferenceValues()
               .subList(fromIndex, toIndex);
      }
   }

   /* *************** End custom fields *********** */

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ComponentImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getComponent();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public PropertyValuesSet getPropertyValuesSet() {
      return propertyValuesSet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetPropertyValuesSet(
         PropertyValuesSet newPropertyValuesSet, NotificationChain msgs) {
      PropertyValuesSet oldPropertyValuesSet = propertyValuesSet;
      propertyValuesSet = newPropertyValuesSet;
      if (eNotificationRequired()) {
         ENotificationImpl notification = new ENotificationImpl(this,
               Notification.SET, SCAPackage.COMPONENT__PROPERTY_VALUES_SET,
               oldPropertyValuesSet, newPropertyValuesSet);
         if (msgs == null)
            msgs = notification;
         else
            msgs.add(notification);
      }
      return msgs;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setPropertyValuesSet(PropertyValuesSet newPropertyValuesSet) {
      if (newPropertyValuesSet != propertyValuesSet) {
         NotificationChain msgs = null;
         if (propertyValuesSet != null)
            msgs = ((InternalEObject) propertyValuesSet)
                  .eInverseRemove(this, EOPPOSITE_FEATURE_BASE
                        - SCAPackage.COMPONENT__PROPERTY_VALUES_SET, null, msgs);
         if (newPropertyValuesSet != null)
            msgs = ((InternalEObject) newPropertyValuesSet)
                  .eInverseAdd(this, EOPPOSITE_FEATURE_BASE
                        - SCAPackage.COMPONENT__PROPERTY_VALUES_SET, null, msgs);
         msgs = basicSetPropertyValuesSet(newPropertyValuesSet, msgs);
         if (msgs != null)
            msgs.dispatch();
      } else if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.COMPONENT__PROPERTY_VALUES_SET, newPropertyValuesSet,
               newPropertyValuesSet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ReferenceValuesSet getReferenceValuesSet() {
      return referenceValuesSet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetReferenceValuesSet(
         ReferenceValuesSet newReferenceValuesSet, NotificationChain msgs) {
      ReferenceValuesSet oldReferenceValuesSet = referenceValuesSet;
      referenceValuesSet = newReferenceValuesSet;
      if (eNotificationRequired()) {
         ENotificationImpl notification = new ENotificationImpl(this,
               Notification.SET, SCAPackage.COMPONENT__REFERENCE_VALUES_SET,
               oldReferenceValuesSet, newReferenceValuesSet);
         if (msgs == null)
            msgs = notification;
         else
            msgs.add(notification);
      }
      return msgs;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setReferenceValuesSet(ReferenceValuesSet newReferenceValuesSet) {
      if (newReferenceValuesSet != referenceValuesSet) {
         NotificationChain msgs = null;
         if (referenceValuesSet != null)
            msgs = ((InternalEObject) referenceValuesSet).eInverseRemove(this,
                  SCAPackage.REFERENCE_VALUES_SET__COMPONENT,
                  ReferenceValuesSet.class, msgs);
         if (newReferenceValuesSet != null)
            msgs = ((InternalEObject) newReferenceValuesSet).eInverseAdd(this,
                  SCAPackage.REFERENCE_VALUES_SET__COMPONENT,
                  ReferenceValuesSet.class, msgs);
         msgs = basicSetReferenceValuesSet(newReferenceValuesSet, msgs);
         if (msgs != null)
            msgs.dispatch();
      } else if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.COMPONENT__REFERENCE_VALUES_SET,
               newReferenceValuesSet, newReferenceValuesSet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getName() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setName(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.COMPONENT__NAME, oldName, name));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseAdd(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.COMPONENT__REFERENCE_VALUES_SET:
               if (referenceValuesSet != null)
                  msgs = ((InternalEObject) referenceValuesSet).eInverseRemove(
                        this, EOPPOSITE_FEATURE_BASE
                              - SCAPackage.COMPONENT__REFERENCE_VALUES_SET,
                        null, msgs);
               return basicSetReferenceValuesSet((ReferenceValuesSet) otherEnd,
                     msgs);
            default:
               return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
         }
      }
      if (eContainer != null)
         msgs = eBasicRemoveFromContainer(msgs);
      return eBasicSetContainer(otherEnd, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.COMPONENT__PROPERTY_VALUES_SET:
               return basicSetPropertyValuesSet(null, msgs);
            case SCAPackage.COMPONENT__REFERENCE_VALUES_SET:
               return basicSetReferenceValuesSet(null, msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT__PROPERTY_VALUES_SET:
            return getPropertyValuesSet();
         case SCAPackage.COMPONENT__REFERENCE_VALUES_SET:
            return getReferenceValuesSet();
         case SCAPackage.COMPONENT__NAME:
            return getName();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT__PROPERTY_VALUES_SET:
            setPropertyValuesSet((PropertyValuesSet) newValue);
            return;
         case SCAPackage.COMPONENT__REFERENCE_VALUES_SET:
            setReferenceValuesSet((ReferenceValuesSet) newValue);
            return;
         case SCAPackage.COMPONENT__NAME:
            setName((String) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT__PROPERTY_VALUES_SET:
            setPropertyValuesSet((PropertyValuesSet) null);
            return;
         case SCAPackage.COMPONENT__REFERENCE_VALUES_SET:
            setReferenceValuesSet((ReferenceValuesSet) null);
            return;
         case SCAPackage.COMPONENT__NAME:
            setName(NAME_EDEFAULT);
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT__PROPERTY_VALUES_SET:
            return propertyValuesSet != null;
         case SCAPackage.COMPONENT__REFERENCE_VALUES_SET:
            return referenceValuesSet != null;
         case SCAPackage.COMPONENT__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (name: "); //$NON-NLS-1$
      result.append(name);
      result.append(')');
      return result.toString();
   }

   /* ************* Begin Custom API ***************** */

   public Composite getComposite() {
      // The owning element will be a Composite.
      return (Composite) eContainer();
   }

   public void setReferenceValue(Reference reference, WireTarget target) {
      ReferenceValue wire = SCAFactory.eINSTANCE.createReferenceValue();
      wire.setReference(reference);
      wire.setTarget(target);
      getReferenceValues().add(wire);
   }

   public List getReferenceValues() {
      if (getReferenceValuesSet() != null)
         return getReferenceValuesSet().getReferenceValues();
      return new ReferenceValuesListDelegate(this);
   }

   public List getReferenceValues(String referenceName) {
      Assert.isNotNullOrEmtpy(referenceName, null);
      List refValues = getReferenceValues();
      if (refValues.isEmpty())
         return Collections.EMPTY_LIST;
      ReferenceValue singleRefValue = null;
      List multipleRefValues = null;
      for (int i = 0; i < refValues.size(); i++) {
         ReferenceValue refValue = (ReferenceValue) refValues.get(i);
         if (referenceName.equals(refValue.getName())) {
            if (singleRefValue == null)
               singleRefValue = refValue;
            else {
               if (multipleRefValues == null) {
                  multipleRefValues = new ArrayList(refValues.size());
                  multipleRefValues.add(singleRefValue);
               }
               multipleRefValues.add(refValue);
            }
         }
      }
      if (multipleRefValues != null)
         return Collections.unmodifiableList(multipleRefValues);
      if (singleRefValue != null)
         return Collections.singletonList(singleRefValue);
      return Collections.EMPTY_LIST;
   }

   public List getReferenceValues(Reference reference) {
      Assert.isNotNull(reference);
      List refValues = getReferenceValues();
      if (refValues.isEmpty())
         return Collections.EMPTY_LIST;
      ReferenceValue singleRefValue = null;
      List multipleRefValues = null;
      for (int i = 0; i < refValues.size(); i++) {
         ReferenceValue refValue = (ReferenceValue) refValues.get(i);
         if (reference.equals(refValue.getReference())) {
            if (singleRefValue == null)
               singleRefValue = refValue;
            else {
               if (multipleRefValues == null) {
                  multipleRefValues = new ArrayList(refValues.size());
                  multipleRefValues.add(singleRefValue);
               }
               multipleRefValues.add(refValue);
            }
         }
      }
      if (multipleRefValues != null)
         return Collections.unmodifiableList(multipleRefValues);
      if (singleRefValue != null)
         return Collections.singletonList(singleRefValue);
      return Collections.EMPTY_LIST;
   }

   public WireTarget getWireTarget(String serviceName) {
      Assert.isNotNullOrEmtpy(serviceName, null);
      WireTarget target = null;
      if (!hasValidAbstractType()) {
         // TODO add error condition
      } else {
         ComponentType type = resolveComponentType();
         List services = type.getServices();
         int size = services.size();
         for (int i = 0; i < size; i++) {
            Service service = (Service) services.get(i);
            if (!serviceName.equals(service.getName()))
               continue;
            target = getWireTargetFromComponentType(service);
            break;
         }
      }
      if (target == null)
         target = createUnresolvedWireTargetHandle(serviceName);
      return target;
   }

   public WireSource getWireSource(String referenceName) {
      Assert.isNotNullOrEmtpy(referenceName, null);
      WireSource source = null;
      if (!hasValidAbstractType()) {
         // TODO add error condition
      } else {
         ComponentType type = resolveComponentType();
         List references = type.getReferences();
         int size = references.size();
         for (int i = 0; i < size; i++) {
            Reference reference = (Reference) references.get(i);
            if (!referenceName.equals(reference.getName()))
               continue;
            source = getWireSourceFromComponentType(reference);
            break;
         }
         source = source == null ? createUnresolvedWireSourceHandle(referenceName)
               : source;
      }
      return source;
   }

   public WireSource getWireSource(Reference reference) {
      Assert.isNotNull(reference);
      WireSource source = null;
      if (!hasValidAbstractType()) {
         // TODO add error condition
      } else {
         ComponentType type = resolveComponentType();
         List references = type.getReferences();
         if (references.contains(reference)) {
            // Good to go.
            source = getWireSourceFromComponentType(reference);
         } else {
            source = createUnresolvedWireSourceHandle(reference.getName());
         }
      }
      return source;
   }

   public WireSource getSingleWireSource() {
      WireSource source = null;
      if (!hasValidAbstractType()) {
         // TODO add error condition
      } else {
         ComponentType type = resolveComponentType();
         List references = type.getReferences();
         if (references.isEmpty() || references.size() > 1) {
            // TODO add error condition because there should only be one
            // service.
            // This is ambiguous...how do we want to capture this.
            source = createUnresolvedWireSourceHandle(EMPTY_STRING);
         } else {
            Reference reference = (Reference) references.get(0);
            source = getWireSourceFromComponentType(reference);
         }
      }
      return source;
   }

   public Collection getWireSourcesWiredToTarget(WireTarget wireTarget) {
      Collection result = null;
      if (getReferenceValuesSet() != null && !getReferenceValues().isEmpty()) {
         Iterator it = getReferenceValues().iterator();
         while (it.hasNext()) {
            ReferenceValue refValue = (ReferenceValue) it.next();
            if (refValue.targets(wireTarget)) {
               if (result == null)
                  result = new ArrayList();
               result.add(getWireSource(refValue.getReference()));
            }
         }
      }
      return result == null ? Collections.EMPTY_LIST : result;
   }

   public WireTarget getWireTarget(Service service) {
      Assert.isNotNull(service);
      WireTarget target = null;

      if (!hasValidAbstractType()) {
         // TODO add error condition
      } else {
         ComponentType type = resolveComponentType();
         if (type.getServices().contains(service)) {
            // Good to go.
            target = getWireTargetFromComponentType(service);
         } else {
            target = createUnresolvedWireTargetHandle(service.getName());
         }
      }
      return target;
   }

   public WireTarget getSingleWireTarget() {
      WireTarget target = null;
      if (!hasValidAbstractType()) {
         // TODO add error condition
      } else {
         ComponentType type = resolveComponentType();
         List services = type.getServices();
         if (services.isEmpty() || services.size() > 1) {
            // TODO add error condition because there should only be one
            // service.
            // This is ambiguous...how do we want to capture this.
            target = createUnresolvedWireTargetHandle(EMPTY_STRING);
         } else {
            Service service = (Service) type.getServices().get(0);
            target = getWireTargetFromComponentType(service);
         }
      }
      return target;
   }

   /*
    * First check if we have created a handle already. If not create one and
    * store a weak reference to it.
    */
   private WireTarget getWireTargetFromComponentType(Service service) {
      String key = service.getName();
      ComponentWireTargetHandle handle = (ComponentWireTargetHandle) getExistingWireHandle(
            targetWireHandles, key);
      if (handle == null) {
         handle = new ComponentWireTargetHandle(this, service);
         if (targetWireHandles == null)
            targetWireHandles = new WeakHashMap();
         targetWireHandles.put(key, handle);
      }
      return handle;
   }

   private ComponentWireSourceHandle createUnresolvedWireSourceHandle(
         String referenceName) {
      // Check for an existing handle
      ComponentWireSourceHandle handle = (ComponentWireSourceHandle) getExistingWireHandle(
            sourceWireHandles, referenceName);
      if (handle == null) {
         handle = new ComponentWireSourceHandle(this, referenceName);
         createdComponentWireSourceHandle(handle, referenceName);
      }
      return handle;
   }

   /*
    * First check if we have created a handle already. If not create one and
    * store a weak reference to it.
    */
   private WireSource getWireSourceFromComponentType(Reference reference) {
      String key = reference.getName();
      ComponentWireSourceHandle handle = (ComponentWireSourceHandle) getExistingWireHandle(
            sourceWireHandles, key);
      if (handle == null) {
         handle = new ComponentWireSourceHandle(this, reference);
         createdComponentWireSourceHandle(handle, key);
      }
      return handle;
   }

   private ComponentWireHandle getExistingWireHandle(Map map, String key) {
      return (ComponentWireHandle) (map == null ? null : map.get(key));
   }

   private void createdComponentWireSourceHandle(
         ComponentWireSourceHandle handle, String referenceName) {
      if (sourceWireHandles == null)
         sourceWireHandles = new WeakHashMap();
      sourceWireHandles.put(referenceName, handle);
   }

   private void createdComponentWireTargetHandle(
         ComponentWireTargetHandle handle, String serviceName) {
      if (targetWireHandles == null)
         targetWireHandles = new WeakHashMap();
      targetWireHandles.put(serviceName, handle);
   }

   private ComponentWireTargetHandle createUnresolvedWireTargetHandle(
         String serviceName) {
      // Check for an existing handle
      ComponentWireTargetHandle handle = (ComponentWireTargetHandle) getExistingWireHandle(
            targetWireHandles, serviceName);
      if (handle == null) {
         handle = new ComponentWireTargetHandle(this, serviceName);
         createdComponentWireTargetHandle(handle, serviceName);
      }
      return handle;
   }

   // private void destroyHandles(Map wireHandles) {
   // if (wireHandles != null && !wireHandles.isEmpty()) {
   // Iterator it = wireHandles.values().iterator();
   // while (it.hasNext()) {
   // ComponentWireHandleImpl handle = (ComponentWireHandleImpl) it.next();
   // if (handle != null)
   // handle.destroy();
   // }
   // }
   // }

   /**
    * Invocations of this method may result in the resolution of the
    * ComponentType.
    * 
    * @return True if and only if the Component has a valid abstract type
    *         available. An AbstractType is the ComponentType contract or some
    *         contract adapted to a ComponentType. Returning true indicates that
    *         resolveComponentType() returns a valid value.
    */
   public boolean hasValidAbstractType() {
      return resolveComponentType() != null;
   }
} // ComponentImpl
