/**
 * <copyright> </copyright>
 * 
 * $Id: ModuleReferenceImpl.java,v 1.1 2006/03/31 21:58:48 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Module Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleReferenceImpl#getExternalService <em>External Service</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ModuleReferenceImpl extends ReferenceImpl implements
      ModuleReference {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright       = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getExternalService() <em>External Service</em>}'
    * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getExternalService()
    * @generated
    * @ordered
    */
   protected ExternalService  externalService = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleReferenceImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getModuleReference();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ExternalService getExternalService() {
      if (externalService != null && ((EObject) externalService).eIsProxy()) {
         ExternalService oldExternalService = externalService;
         externalService = (ExternalService) eResolveProxy((InternalEObject) externalService);
         if (externalService != oldExternalService) {
            if (eNotificationRequired())
               eNotify(new ENotificationImpl(this, Notification.RESOLVE,
                     SCAPackage.MODULE_REFERENCE__EXTERNAL_SERVICE,
                     oldExternalService, externalService));
         }
      }
      return externalService;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ExternalService basicGetExternalService() {
      return externalService;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setExternalService(ExternalService newExternalService) {
      ExternalService oldExternalService = externalService;
      externalService = newExternalService;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.MODULE_REFERENCE__EXTERNAL_SERVICE,
               oldExternalService, externalService));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.MODULE_REFERENCE__INTERFACE_GROUP:
               return ((InternalEList) getInterfaceGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.MODULE_REFERENCE__INTERFACE:
               return basicSetInterface(null, msgs);
            case SCAPackage.MODULE_REFERENCE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE_REFERENCE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_REFERENCE__INTERFACE_GROUP:
            return getInterfaceGroup();
         case SCAPackage.MODULE_REFERENCE__INTERFACE:
            return getInterface();
         case SCAPackage.MODULE_REFERENCE__ANY:
            return getAny();
         case SCAPackage.MODULE_REFERENCE__MULTIPLICITY:
            return getMultiplicity();
         case SCAPackage.MODULE_REFERENCE__NAME:
            return getName();
         case SCAPackage.MODULE_REFERENCE__ANY_ATTRIBUTE:
            return getAnyAttribute();
         case SCAPackage.MODULE_REFERENCE__EXTERNAL_SERVICE:
            if (resolve)
               return getExternalService();
            return basicGetExternalService();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_REFERENCE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            getInterfaceGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_REFERENCE__INTERFACE:
            setInterface((Interface) newValue);
            return;
         case SCAPackage.MODULE_REFERENCE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_REFERENCE__MULTIPLICITY:
            setMultiplicity((String) newValue);
            return;
         case SCAPackage.MODULE_REFERENCE__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.MODULE_REFERENCE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_REFERENCE__EXTERNAL_SERVICE:
            setExternalService((ExternalService) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_REFERENCE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            return;
         case SCAPackage.MODULE_REFERENCE__INTERFACE:
            setInterface((Interface) null);
            return;
         case SCAPackage.MODULE_REFERENCE__ANY:
            getAny().clear();
            return;
         case SCAPackage.MODULE_REFERENCE__MULTIPLICITY:
            unsetMultiplicity();
            return;
         case SCAPackage.MODULE_REFERENCE__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.MODULE_REFERENCE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
         case SCAPackage.MODULE_REFERENCE__EXTERNAL_SERVICE:
            setExternalService((ExternalService) null);
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_REFERENCE__INTERFACE_GROUP:
            return interfaceGroup != null && !interfaceGroup.isEmpty();
         case SCAPackage.MODULE_REFERENCE__INTERFACE:
            return getInterface() != null;
         case SCAPackage.MODULE_REFERENCE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.MODULE_REFERENCE__MULTIPLICITY:
            return isSetMultiplicity();
         case SCAPackage.MODULE_REFERENCE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.MODULE_REFERENCE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
         case SCAPackage.MODULE_REFERENCE__EXTERNAL_SERVICE:
            return externalService != null;
      }
      return eDynamicIsSet(eFeature);
   }

   /* ********* Begin Customizations ********** */

   public void setInterface(Interface newInterface) {
      if (externalService != null)
         externalService.setInterface(newInterface);
      else
         super.setInterface(newInterface);
   }

   public Interface getInterface() {
      if (externalService != null)
         return externalService.getInterface();
      return super.getInterface();
   }

   public void setName(String newName) {
      if (externalService != null)
         externalService.setName(newName);
      super.setName(newName);
   }

   public String getName() {
      if (externalService != null)
         return externalService.getName();
      return super.getName();
   }

   public int getFlags() {
      return super.getFlags() | IConstants.F_BINDABLE_ELEMENT;
   }

} // ModuleReferenceImpl
