/**
 * <copyright> </copyright>
 * 
 * $Id: ReferenceValueImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WireTarget;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Reference Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceValueImpl#getTargetURI <em>Target URI</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceValueImpl#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceValueImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceValueImpl#getReferenceValueSet <em>Reference Value Set</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ReferenceValueImpl extends SCAInternalObjectImpl implements
      ReferenceValue {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright           = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The default value of the '{@link #getTargetURI() <em>Target URI</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getTargetURI()
    * @generated
    * @ordered
    */
   protected static final String TARGET_URI_EDEFAULT = null;

   /**
    * The cached value of the '{@link #getTargetURI() <em>Target URI</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getTargetURI()
    * @generated
    * @ordered
    */
   protected String              targetURI           = TARGET_URI_EDEFAULT;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String NAME_EDEFAULT       = null;

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String              name                = NAME_EDEFAULT;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap          anyAttribute        = null;

   /*
    * This field will hold the {@link Reference} that is resolved based on the
    * {@link #name} field.
    */
   private Reference             resolvedReference;

   private boolean               hasResolvedReference;

   // Boolean indicating if the targetURI has been parsed.
   private boolean               hasParsedTargetURI;

   // The WireTarget that the targetURI resolved to.
   private WireTarget            resolvedWireTarget;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ReferenceValueImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getReferenceValue();
   }

   public String getTargetURI() {
      if (resolvedWireTarget != null)
         return resolvedWireTarget.getName();
      return getTargetURIGen();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getTargetURIGen() {
      return targetURI;
   }

   /*
    * If the targetURI has changed then reset the resolved target references as
    * well as the flags used to resolve these target references.
    * 
    * @see org.eclipse.stp.core.sca.ReferenceValue#setTargetURI(java.lang.String)
    */
   public void setTargetURI(String newTargetURI) {
      if (newTargetURI != targetURI
            && ((newTargetURI != null && !newTargetURI.equals(targetURI)) || (targetURI != null && !targetURI
                  .equals(newTargetURI)))) {
         resolvedWireTarget = null;
         hasParsedTargetURI = false;
      }
      setTargetURIGen(newTargetURI);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setTargetURIGen(String newTargetURI) {
      String oldTargetURI = targetURI;
      targetURI = newTargetURI;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.REFERENCE_VALUE__TARGET_URI, oldTargetURI, targetURI));
   }

   /**
    * Return the name of the underlying {@link Reference}.
    * 
    * @return String
    */
   public String getName() {
      if (hasResolvedReference && resolvedReference != null)
         return resolvedReference.getName();
      return getNameGen();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getNameGen() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setNameGen(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.REFERENCE_VALUE__NAME, oldName, name));
   }

   /*
    * If the newName is different from the set name then reset the
    * resolvedReference.
    */
   public void setName(String newName) {
      if (newName != name
            && ((newName != null && !newName.equals(name)) || (name != null && !name
                  .equals(newName))))
         resolvedReference = null;
      setNameGen(newName);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.REFERENCE_VALUE__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ReferenceValuesSet getReferenceValueSet() {
      if (eContainerFeatureID != SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET)
         return null;
      return (ReferenceValuesSet) eContainer;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setReferenceValueSet(ReferenceValuesSet newReferenceValueSet) {
      if (newReferenceValueSet != eContainer
            || (eContainerFeatureID != SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET && newReferenceValueSet != null)) {
         if (EcoreUtil.isAncestor(this, (EObject) newReferenceValueSet))
            throw new IllegalArgumentException(
                  "Recursive containment not allowed for " + toString()); //$NON-NLS-1$
         NotificationChain msgs = null;
         if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
         if (newReferenceValueSet != null)
            msgs = ((InternalEObject) newReferenceValueSet).eInverseAdd(this,
                  SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES,
                  ReferenceValuesSet.class, msgs);
         msgs = eBasicSetContainer((InternalEObject) newReferenceValueSet,
               SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET, msgs);
         if (msgs != null)
            msgs.dispatch();
      } else if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET,
               newReferenceValueSet, newReferenceValueSet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseAdd(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET:
               if (eContainer != null)
                  msgs = eBasicRemoveFromContainer(msgs);
               return eBasicSetContainer(otherEnd,
                     SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET, msgs);
            default:
               return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
         }
      }
      if (eContainer != null)
         msgs = eBasicRemoveFromContainer(msgs);
      return eBasicSetContainer(otherEnd, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.REFERENCE_VALUE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET:
               return eBasicSetContainer(null,
                     SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET, msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
      if (eContainerFeatureID >= 0) {
         switch (eContainerFeatureID) {
            case SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET:
               return eContainer.eInverseRemove(this,
                     SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES,
                     ReferenceValuesSet.class, msgs);
            default:
               return eDynamicBasicRemoveFromContainer(msgs);
         }
      }
      return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE
            - eContainerFeatureID, null, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUE__TARGET_URI:
            return getTargetURI();
         case SCAPackage.REFERENCE_VALUE__NAME:
            return getName();
         case SCAPackage.REFERENCE_VALUE__ANY_ATTRIBUTE:
            return getAnyAttribute();
         case SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET:
            return getReferenceValueSet();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUE__TARGET_URI:
            setTargetURI((String) newValue);
            return;
         case SCAPackage.REFERENCE_VALUE__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.REFERENCE_VALUE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
         case SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET:
            setReferenceValueSet((ReferenceValuesSet) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUE__TARGET_URI:
            setTargetURI(TARGET_URI_EDEFAULT);
            return;
         case SCAPackage.REFERENCE_VALUE__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.REFERENCE_VALUE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
         case SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET:
            setReferenceValueSet((ReferenceValuesSet) null);
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUE__TARGET_URI:
            return TARGET_URI_EDEFAULT == null ? targetURI != null
                  : !TARGET_URI_EDEFAULT.equals(targetURI);
         case SCAPackage.REFERENCE_VALUE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.REFERENCE_VALUE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
         case SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET:
            return getReferenceValueSet() != null;
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (targetURI: "); //$NON-NLS-1$
      result.append(targetURI);
      result.append(", name: "); //$NON-NLS-1$
      result.append(name);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   public void setTarget(WireTarget wireTarget) {
      resolvedWireTarget = wireTarget;
      // We must set the targetURI if it hasn't been set yet so
      // that the serializer will call getTargetURI().
      if (wireTarget != null && targetURI == null)
         setTargetURIGen(wireTarget.getName());
   }

   public Reference getReference() {
      if (!hasResolvedReference) {
         hasResolvedReference = true;
         resolvedReference = resolveReferenceFromName();
      }
      return resolvedReference;
   }

   /*
    * Resolve a {@link Reference} from the {@link ComponentType} of the owning
    * {@link Component} based on the {@link #name}.
    */
   private Reference resolveReferenceFromName() {
      if (getNameGen() != null) {
         Component component = getOwningComponent();
         if (component != null) {
            ComponentType type = component.resolveComponentType();
            if (type != null)
               return type.getReference(getNameGen());
         }
      }
      return null;
   }

   public void setReference(Reference reference) {
      Assert.isNotNull(reference);
      hasResolvedReference = true;
      resolvedReference = reference;
      // If the name is not set yet we must do it now for serialization to work.
      if (!eIsSet(SCAPackage.eINSTANCE.getReferenceValue_Name()))
         setNameGen(reference.getName());
   }

   public WireTarget getTarget() {
      if (!hasParsedTargetURI)
         parseTargetURI();
      return resolvedWireTarget;
   }

   public Component getOwningComponent() {
      ReferenceValuesSet set = getReferenceValueSet();
      return set == null ? null : set.getComponent();
   }

   /*
    * The targetURI for a Component will be in the form "[Component name]/[opt
    * service name]". The service name is optional if there is only one service
    * on the Component. It is an error condition if the service name is not
    * provided and there is more than one service on the component.
    * 
    * The target URI for an ExternalService will be in the form
    * "[ExternalService name]". No service name is required for an
    * ExternalService since it is by definition a single service.
    */
   private void parseTargetURI() {
      if (!hasParsedTargetURI) {
         Composite composite = getComposite();
         if (composite != null) {
            hasParsedTargetURI = true;
            resolvedWireTarget = composite.resolveWireTarget(getTargetURI());
         }
      }
   }

   private Composite getComposite() {
      Component component = getOwningComponent();
      return component != null ? component.getComposite() : null;
   }

   public boolean targets(WireTarget wireTarget) {
      if (wireTarget != null) {
         if (wireTarget.equals(resolvedWireTarget))
            return true;
         return wireTarget.getName() != null
               && wireTarget.getName().equals(getTargetURI());
      }
      return false;
   }

} // ReferenceValueImpl
