/**
 * <copyright> </copyright>
 * 
 * $Id: ExternalServiceItemProvider.java,v 1.2 2006/04/05 14:26:13 melder Exp $
 */
package org.eclipse.stp.core.sca.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * This is the item provider adapter for a
 * {@link org.eclipse.stp.core.sca.ExternalService} object. <!-- begin-user-doc
 * --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class ExternalServiceItemProvider extends ItemProviderAdapter implements
      IEditingDomainItemProvider, IStructuredItemContentProvider,
      ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * This constructs an instance from a factory and a notifier. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ExternalServiceItemProvider(AdapterFactory adapterFactory) {
      super(adapterFactory);
   }

   /**
    * This returns the property descriptors for the adapted class. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertyDescriptors(Object object) {
      if (itemPropertyDescriptors == null) {
         super.getPropertyDescriptors(object);

         addNamePropertyDescriptor(object);
         addOverridablePropertyDescriptor(object);
      }
      return itemPropertyDescriptors;
   }

   /**
    * This adds a property descriptor for the Name feature. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addNamePropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_ExternalService_name_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_ExternalService_name_feature", "_UI_ExternalService_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getExternalService_Name(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This adds a property descriptor for the Overridable feature. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addOverridablePropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_ExternalService_overridable_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_ExternalService_overridable_feature", "_UI_ExternalService_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getExternalService_Overridable(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This specifies how to implement {@link #getChildren} and is used to deduce
    * an appropriate feature for an
    * {@link org.eclipse.emf.edit.command.AddCommand},
    * {@link org.eclipse.emf.edit.command.RemoveCommand} or
    * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Collection getChildrenFeatures(Object object) {
      if (childrenFeatures == null) {
         super.getChildrenFeatures(object);
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getExternalService_BindingGroup());
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getExternalService_InterfaceGroup());
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getExternalService_Interface());
         childrenFeatures.add(SCAPackage.eINSTANCE.getExternalService_Any());
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getExternalService_AnyAttribute());
      }
      return childrenFeatures;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EStructuralFeature getChildFeature(Object object, Object child) {
      // Check the type of the specified child object and return the proper
      // feature to use for
      // adding (see {@link AddCommand}) it as a child.

      return super.getChildFeature(object, child);
   }

   /**
    * This returns ExternalService.gif. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public Object getImage(Object object) {
      return getResourceLocator().getImage("full/obj16/ExternalService"); //$NON-NLS-1$
   }

   /**
    * This returns the label text for the adapted class. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getText(Object object) {
      String label = ((ExternalService) object).getName();
      return label == null || label.length() == 0 ? getString("_UI_ExternalService_type") : //$NON-NLS-1$
            getString("_UI_ExternalService_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
   }

   /**
    * This handles model notifications by calling {@link #updateChildren} to
    * update any cached children and by creating a viewer notification, which it
    * passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public void notifyChanged(Notification notification) {
      updateChildren(notification);

      switch (notification.getFeatureID(ExternalService.class)) {
         case SCAPackage.EXTERNAL_SERVICE__NAME:
         case SCAPackage.EXTERNAL_SERVICE__OVERRIDABLE:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), false, true));
            return;
         case SCAPackage.EXTERNAL_SERVICE__BINDING_GROUP:
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE_GROUP:
         case SCAPackage.EXTERNAL_SERVICE__INTERFACE:
         case SCAPackage.EXTERNAL_SERVICE__ANY:
         case SCAPackage.EXTERNAL_SERVICE__ANY_ATTRIBUTE:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), true, false));
            return;
      }
      super.notifyChanged(notification);
   }

   /**
    * This adds to the collection of
    * {@link org.eclipse.emf.edit.command.CommandParameter}s describing all of
    * the children that can be created under this object. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void collectNewChildDescriptors(Collection newChildDescriptors,
         Object object) {
      super.collectNewChildDescriptors(newChildDescriptors, object);

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_BindingGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getExternalService_Bindings(),
            SCAFactory.eINSTANCE.createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_BindingGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getExternalService_Bindings(),
            SCAFactory.eINSTANCE.createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_BindingGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getExternalService_Bindings(),
            SCAFactory.eINSTANCE.createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_BindingGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getExternalService_Bindings(),
            SCAFactory.eINSTANCE.createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_BindingGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingSca(),
            SCAFactory.eINSTANCE.createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_BindingGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingWs(),
            SCAFactory.eINSTANCE.createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_BindingGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingEjb(),
            SCAFactory.eINSTANCE.createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_InterfaceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getExternalService_Interface(),
            SCAFactory.eINSTANCE.createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_InterfaceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getExternalService_Interface(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_InterfaceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getExternalService_Interface(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_InterfaceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_InterfaceWsdl(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_InterfaceGroup(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_InterfaceJava(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_Interface(), SCAFactory.eINSTANCE
            .createInterface()));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_Interface(), SCAFactory.eINSTANCE
            .createJavaInterface()));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getExternalService_Interface(), SCAFactory.eINSTANCE
            .createWSDLPortType()));
   }

   /**
    * This returns the label text for
    * {@link org.eclipse.emf.edit.command.CreateChildCommand}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getCreateChildText(Object owner, Object feature, Object child,
         Collection selection) {
      Object childFeature = feature;
      Object childObject = child;

      if (childFeature instanceof EStructuralFeature
            && FeatureMapUtil.isFeatureMap((EStructuralFeature) childFeature)) {
         FeatureMap.Entry entry = (FeatureMap.Entry) childObject;
         childFeature = entry.getEStructuralFeature();
         childObject = entry.getValue();
      }

      boolean qualify = childFeature == SCAPackage.eINSTANCE
            .getExternalService_Bindings()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_BindingSca()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_BindingEjb()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_BindingWs()
            || childFeature == SCAPackage.eINSTANCE
                  .getExternalService_Interface()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_InterfaceJava()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_InterfaceWsdl();

      if (qualify) {
         return getString("_UI_CreateChild_text2", //$NON-NLS-1$
               new Object[] { getTypeText(childObject),
                     getFeatureText(childFeature), getTypeText(owner) });
      }
      return super.getCreateChildText(owner, feature, child, selection);
   }

   /**
    * Return the resource locator for this item provider's resources. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ResourceLocator getResourceLocator() {
      return STPCorePlugin.INSTANCE;
   }

}
