/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.ui.contribution;

/**
 * Provides details of a tab that is required to display an object using the {@link ISOAPropertiesContribution}.
 * 
 * @see org.eclipse.stp.core.saf.ui.contribution.ISOAPropertiesContribution#getTabDescriptors()
 */

public interface ITabDescriptor {
	/**
	 * Return the name of the tab.
	 * 
	 * @return Name to assign to the tab. This name must be translatable.
	 */
	public String getTabName();
	
	/**
	 * Returns the {@link ISOAPropertiesContribution}, which is used to create the contents (the
	 * control) in the tabbed page
	 * 
	 * @return The {@link ISOAPropertiesContribution}, which creates the contents of the tabbed page
	 */
	public ISOAPropertiesContribution getContribution();
}
