/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.operations;

import java.util.Set;

import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/**
 *
 */
public class BindingDeletionDataModelProvider extends AbstractDataModelProvider implements IBindingDeletionDataModelProperties {
	
	/**
	 * 
	 */
	public BindingDeletionDataModelProvider() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel#getDefaultOperation()
	 */
	public IDataModelOperation getDefaultOperation() {
		return new BindingDeletionOperation(getDataModel());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider#getPropertyNames()
	 */
	public Set getPropertyNames() {
		Set propertyNames = super.getPropertyNames();
		
		propertyNames.add(SCAOBJECT);
		propertyNames.add(BINDING_TYPE);
		propertyNames.add(REMOVE_ALL);
				
		return propertyNames;		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider#getDefaultProperty(java.lang.String)
	 */
	public Object getDefaultProperty(String propertyName) {
		
		if (REMOVE_ALL.equals(propertyName))
			return new Boolean (false);
		
		return super.getDefaultProperty(propertyName);
	}

}
