/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.saf.impl;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/**
 * the main plugin class to be used in the desktop
 */
public class SAFActivator extends Plugin {

	//the shared instance
	private static SAFActivator plugin;
	private static String pluginID = null;
	
	/**
	 * the constructor.
	 */
	public SAFActivator() {
		plugin = this;
	}

	/**
	 * This method is called when the plug-in is activated.
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		pluginID = getBundle().getSymbolicName();
	}

	/**
	 * This method is called when the plug-in is stopped.
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * @return the shared instance
	 */
	public static SAFActivator getDefault() {
		return plugin;
	}

	/**
	 * @return the plugin's resource bundle
	 */
	public ResourceBundle getResourceBundle() {
		try {
			return Platform.getResourceBundle(getBundle());
		}
		catch (MissingResourceException e) {
			return null;
		}
	}

	/**
	 * Returns the list of extensions that extend the "handlers" extension
	 * point of this plug-in.
	 * @return an array of matching extensions
	 */
	public IExtension[] getHandlerContributions() {
		
		// Note: The identifier below must match the extension point ID in plugin.xml.
		
		IExtension[] extensions = null;
		
		// Note: The identifier below must match the plug-in ID in plugin.xml.
		IExtensionPoint extensionPoint =
			Platform.getExtensionRegistry()
			        .getExtensionPoint(ISAFConstants.PLUGIN_ID,
		                               ISAFConstants.HANDLERS_EXT_POINT_ID );
		if (extensionPoint != null) {
			extensions = extensionPoint.getExtensions();
		}//if
		
		return extensions;
	}//getComponentImplementationHandlerExtensions()
	
	/**
	 * Returns the list of extensions that extend the "context" extension
	 * point of this plugin.
	 * @return An array of matching extensions
	 */
	public IExtension[] getContextContibutions() {
		
		// Note: The identifier below must match the extension point ID in plugin.xml.
		
		IExtension[] extensions = null;
		
		// Note: The identifier below must match the plug-in ID in plugin.xml.
		IExtensionPoint extensionPoint =
			Platform.getExtensionRegistry()
			        .getExtensionPoint(ISAFConstants.PLUGIN_ID,
		                               ISAFConstants.CONTEXT_EXT_POINT_ID );
		if (extensionPoint != null) {
			extensions = extensionPoint.getExtensions();
		}//if
		
		return extensions;
	}//getContextContibutions()
	
	/**
	 * Returns the list of extensions that extend the "contextExtension" extension
	 * point of this plugin.
	 * @return An array of matching extensions
	 */
	public IExtension[] getContextExtensionContibutions() {
		
		// Note: The identifier below must match the extension point ID in plugin.xml.
		
		IExtension[] extensions = null;
		
		// Note: The identifier below must match the plug-in ID in plugin.xml.
		IExtensionPoint extensionPoint =
			Platform.getExtensionRegistry()
			        .getExtensionPoint(ISAFConstants.PLUGIN_ID,
		                               ISAFConstants.CONTEXTEXTENSION_EXT_POINT_ID );
		if (extensionPoint != null) {
			extensions = extensionPoint.getExtensions();
		}//if
		
		return extensions;
	}//getContextExtensionContibutions()
	
	/**
	 * @return eclipse log
	 */
	public static ILog getLogger(){
		return SAFActivator.getDefault().getLog();	
	}
	
	/**
	 * @param msgSource
	 * @param methodName
	 * @param level
	 * @param message
	 */
	public static void log(Object msgSource, String methodName, int level, String message) {
		if (message == null) {
			message = ""; //$NON-NLS-1$
		}
	
		SAFActivator.getLogger().log( new Status(level, pluginID, IStatus.OK, message, null) );
	}

	/**
	 * @param msgSource
	 * @param methodName
	 * @param level
	 * @param exc
	 */
	public static void log(Object msgSource, String methodName, int level, Throwable exc) {
		SAFActivator.getLogger().log( new Status(level, pluginID, IStatus.OK, "", exc) ); //$NON-NLS-1$
	}

	/**
	 * @param msgSource
	 * @param methodName
	 * @param level
	 * @param message
	 * @param exc
	 */
	public static void log(Object msgSource, String methodName, int level, String message, Throwable exc) {
		if (message == null) {
			message = ""; //$NON-NLS-1$
		}
		SAFActivator.getLogger().log( new Status(level, pluginID, IStatus.OK, message, exc) );
	}
	
	public static void log(Object msgSource, String methodName, IStatus status) {
		SAFActivator.getLogger().log( status );
	}
	
	public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
		return new Status(severity, pluginID, aCode, aMessage, exception);
	}

	public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
		return createStatus(IStatus.ERROR, aCode, aMessage, exception);
	}

	public static IStatus createErrorStatus(String aMessage, Throwable exception) {
		return createStatus(IStatus.ERROR, 0, aMessage, exception);
	}
}
