/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AnnotationAttributePage;
import org.eclipse.stp.sc.jaxws.wizards.annotations.CreateAnnotationWizard;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.MethodSelectionPage2;

public class CreateWebMethodWizard
extends CreateAnnotationWizard {
    public static final String DATA_KEY_SELECTED_METHODS = "DATA_KEY_SELECTED_METHODS";
    public static final String DATA_KEY_RESULT_VALUES = "DATA_KEY_RESULT_VALUES";
    public static final String DATA_KEY_ONEWAY_VALUES = "DATA_KEY_ONEWAY_VALUES";
    public static final String DATA_KEY_REQUEST_VALUES = "DATA_KEY_REQUEST_VALUES";
    public static final String DATA_KEY_RESPONSE_VALUES = "DATA_KEY_RESPONSE_VALUES";
    public static final String SELECTION_PAGE = "selectionPage";

    public CreateWebMethodWizard(IMember aMember) {
        super(aMember);
        String title = ScJaxWsResources.getString("CreateWebMethodWizard.Title");
        this.setWindowTitle(title);
        this.ANNOTATION_REQUIRED.put(WebMethod.class, true);
        this.ANNOTATION_REQUIRED.put(RequestWrapper.class, true);
        this.ANNOTATION_REQUIRED.put(WebResult.class, false);
        this.ANNOTATION_REQUIRED.put(ResponseWrapper.class, true);
        this.ANNOTATION_REQUIRED.put(Oneway.class, false);
    }

    public void initializeWizardData(IMember targetMember) {
        super.initializeWizardData(targetMember);
        if (targetMember instanceof IMethod) {
            IMethod[] methods = new IMethod[]{(IMethod)targetMember};
            this.wizardData.put(DATA_KEY_SELECTED_METHODS, methods);
        }
    }

    public void addPages() {
        super.addPages();
        if (!(this.getOriginalWizardTargetFromData() instanceof IMember)) {
            return;
        }
        IMember member = (IMember)this.getOriginalWizardTargetFromData();
        if (member instanceof IType) {
            this.addPage((IWizardPage)new MethodSelectionPage2(this, SELECTION_PAGE, null));
        }
        if (PreferencesAccessor.areAnnWizardsDisplaied()) {
            this.addPage((IWizardPage)new AnnotationAttributePage(this, null, null, WebMethod.class, (Boolean)this.ANNOTATION_REQUIRED.get(WebMethod.class)));
            this.addPage((IWizardPage)new AnnotationAttributePage(this, null, null, RequestWrapper.class, (Boolean)this.ANNOTATION_REQUIRED.get(RequestWrapper.class)));
            if (member instanceof IMethod && this.hasAResponse((IMethod)member) || !(member instanceof IMethod)) {
                this.addPage((IWizardPage)new AnnotationAttributePage(this, null, null, WebResult.class, (Boolean)this.ANNOTATION_REQUIRED.get(WebResult.class)));
                this.addPage((IWizardPage)new AnnotationAttributePage(this, null, null, ResponseWrapper.class, (Boolean)this.ANNOTATION_REQUIRED.get(ResponseWrapper.class)));
            }
            if (member instanceof IMethod && this.isValidOneway((IMethod)member) || !(member instanceof IMethod)) {
                this.addPage((IWizardPage)new AnnotationAttributePage(this, null, null, Oneway.class, (Boolean)this.ANNOTATION_REQUIRED.get(Oneway.class)));
            }
        }
    }

    protected boolean updateAST(CompilationUnit astRoot, ASTRewrite astRewrite) {
        int updateCnt = 0;
        IMethod[] selMethods = (IMethod[])this.wizardData.get(DATA_KEY_SELECTED_METHODS);
        int i = 0;
        while (i < selMethods.length) {
            IMethod methodMember = selMethods[i];
            for (Class annClass : this.ANNOTATION_REQUIRED.keySet()) {
                if (!this.addAnnotationToMethodMember(astRoot, astRewrite, methodMember, annClass, (Boolean)this.ANNOTATION_REQUIRED.get(annClass))) continue;
                ++updateCnt;
            }
            ++i;
        }
        return updateCnt > 0;
    }

    private boolean hasAResponse(IMethod method) {
        try {
            return !method.getReturnType().equals("V");
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean isValidOneway(IMethod method) {
        try {
            if (!method.getReturnType().equals("V")) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        String[] params = method.getParameterTypes();
        if (params.length != 1) {
            return false;
        }
        int j = 0;
        while (j < params.length) {
            String elementType = Signature.getElementType((String)params[j]);
            if (elementType.equals("QHolder;")) {
                return false;
            }
            ++j;
        }
        try {
            return method.getExceptionTypes().length == 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

