/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws;

import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class ScJaxWsPlugin extends AbstractUIPlugin {
    
    public static final String EXT_POINT_SC_JAXWS_RUNTIME = "org.eclipse.stp.sc.jaxws.runtimeProvider";
    // The plug-in ID
    public static final String PLUGIN_ID = "org.eclipse.stp.sc.jaxws";

    // The shared instance
    private static ScJaxWsPlugin plugin;
    
    /**
     * The constructor
     */
    public ScJaxWsPlugin() {
        plugin = this;
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static ScJaxWsPlugin getDefault() {
        return plugin;
    }
    

    public static IRuntimeProviderManager getRuntimeProviderManager() {
        return RuntimeProviderManager.getInstance();
    }
}
