/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.annotations;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;


public abstract class WebAnnInfo {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TARGETNAMESPACE = "targetNamespace";
    public static final String ATTR_HEADER = "header";
    public static final String ATTR_PARTNAME = "partName";
    protected String name;
    protected String targetNamespace;
    boolean header;
    String partName;

    public WebAnnInfo() {
    }
    
    public WebAnnInfo(Annotation ann) {
        NormalAnnotation normalAnn = (NormalAnnotation)ann;
        List list = normalAnn.values();
        Iterator itor = list.iterator();

        while (itor.hasNext()) {
            MemberValuePair valuePair = (MemberValuePair)itor.next();
            String attrKey = valuePair.getName().getFullyQualifiedName();
            String value = "";
            if (valuePair.getValue() instanceof StringLiteral) {
                value = ((StringLiteral)valuePair.getValue()).getLiteralValue();
            }

            if (attrKey.equals(ATTR_NAME)) {
                name = value;
            } else if (attrKey.equals(ATTR_TARGETNAMESPACE)) {
                targetNamespace = value;
            }
        }
    }

    public boolean isHeader() {
        return header;
    }

    public void setHeader(boolean value) {
        this.header = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String value) {
        this.partName = value;
    }

    public String getTargetNamespace() {
        return targetNamespace;
    }

    public void setTargetNamespace(String value) {
        this.targetNamespace = value;
    }
}
