/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.preferences;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SCMainPreferencePage extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {
    private IPreferenceStore mStore;
    
    /*private FileFieldEditor m_celtixJar;
    private FileFieldEditor m_jaxwsJar;*/
    public SCMainPreferencePage() {
        super(GRID);
        mStore = ScJaxWsPlugin.getDefault().getPreferenceStore();
        setPreferenceStore(mStore);
    }

    @Override
    protected void adjustGridLayout() {
        // disable
    }
    
   
    @Override
    protected void createFieldEditors() {
        createKitInstallGroup(null);
        createAnnotationWizardsGroup(null);
        createCodeGenGroup(null);
    }

    private void createKitInstallGroup(Composite parentContainer) {
        Group grpKitInstall = new Group(getFieldEditorParent(), SWT.NONE);
        grpKitInstall.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
        grpKitInstall.setLayout(new FillLayout());
        grpKitInstall.setText(ScJaxWsResources.getString("pref.jaxws.install.grp"));
        
        IExtension[] exts = RuntimeProviderManager.getInstance().getAllRegistredProviders();
        for (int i = 0; i < exts.length; i++) {
            IExtension extension = exts[i];
            String fieldKey = 
                PreferencesAccessor.resolvePrefKey(SCPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT,
                                                   extension.getUniqueIdentifier());
            DirectoryFieldEditor kitInstallDirField = new DirectoryFieldEditor(fieldKey,
                                                                               extension.getLabel(),
                                                                               grpKitInstall);
            addField(kitInstallDirField);
        }
    }

    private void createAnnotationWizardsGroup(Composite parentContainer) {
    	Group grpAnnWiz = new Group(getFieldEditorParent(), SWT.NONE);
    	grpAnnWiz.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
    	grpAnnWiz.setLayout(new FillLayout());
    	grpAnnWiz.setText(ScJaxWsResources.getString("pref.jaxws.ann.wiz.grp"));
    	
    	String[][] values = new String[][]{{ScJaxWsResources.getString("pref.jaxws.ann.wiz.enable.lbl"),
    		SCPreferenceConstants.VAL_ANN_WIZ_ENABLED},
    		{ScJaxWsResources.getString("pref.jaxws.ann.wiz.disable.lbl"), 
    			SCPreferenceConstants.VAL_ANN_WIZ_DISABLED}};
    	RadioGroupFieldEditor wizOptionField = 
    		new RadioGroupFieldEditor(SCPreferenceConstants.KEY_ANN_WIZ_ENABLED,
    				"Wizards visbility",
    				1,
    				values,
    				grpAnnWiz);
    	addField(wizOptionField);
    }
    private void createCodeGenGroup(Composite parentContainer) {
        Group grpCodegenWiz = new Group(getFieldEditorParent(), SWT.NONE);
        grpCodegenWiz.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
        grpCodegenWiz.setLayout(new FillLayout());
        grpCodegenWiz.setText(ScJaxWsResources.getString("pref.jaxws.codegen.grp"));
        
        BooleanFieldEditor mergeField = new BooleanFieldEditor(SCPreferenceConstants.KEY_MERGE,
        		ScJaxWsResources.getString("pref.jaxws.codegen.merge.lbel"), grpCodegenWiz);
        addField(mergeField);
    }
    
   

    public void init(IWorkbench workbench) {
        // TODO Auto-generated method stub
    }
}
