/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * @author jma
 *
 */
public class WsdlGenPage extends WizardPage {


    
    protected IParameterPage paramPage;
    
    protected WsdlGenPage(String pageName) {
        super(pageName);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite parent) {
        Group grpParams = new Group(parent, SWT.NONE);
        grpParams.setLayoutData(new GridData(GridData.FILL_BOTH));
        grpParams.setLayout(new GridLayout(1, false));
        grpParams.setText(ScJaxWsResources.getString("Wsdl.To.Java.Gen.Param.Title"));
        
        IRuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
        
        String providerID = RuntimeProviderManager.getInstance().pickAProvider();
        
        paramPage = rtMgr.getParameterPage(providerID);
        paramPage.createContents(grpParams);
        paramPage.setPage(this);
        paramPage.validateParams();
        
        this.setControl(grpParams);
    }
    
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
        	WsdlFirstProjectWizard wizard = (WsdlFirstProjectWizard)this.getWizard();
            paramPage.setWsdlUrl(wizard.getWsdlURL());
        }
    }

}
