/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.sca.java.preferences;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.sc.sca.java.ScaJavaPlugin;
import org.eclipse.stp.sc.sca.java.ScaJavaResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * @author jma
 * Holding preference page for SCA.Java
 * such as java runtime kit location, code merge flag...etc
 */
public class ScaJavaPreferencePage extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {

	private IPreferenceStore mStore;
	public ScaJavaPreferencePage() {
        super(GRID);
        mStore = ScaJavaPlugin.getDefault().getPreferenceStore();
        setPreferenceStore(mStore);
    }
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	@Override
	protected void createFieldEditors() {
		createRuntimeGroup(getFieldEditorParent());
    }
	
	private void createRuntimeGroup(Composite parentContainer) {
		Group grpRuntime = new Group(parentContainer, SWT.NONE);
		grpRuntime.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
		grpRuntime.setLayout(new FillLayout());
		grpRuntime.setText(ScaJavaResources.getString("pref.sca.java.grp.runtime"));
		//TODO, need to decouple runtime here, reuse runtime provider in jaxws?
        DirectoryFieldEditor kitInstallDirField = new DirectoryFieldEditor(
        		ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT,
                "Apache Tuscany",
                grpRuntime);
        addField(kitInstallDirField);
	}

	public void init(IWorkbench workbench) {
		
	}

}
