/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.sca.java.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.sc.sca.java.ScaJavaResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

/**
 * @author jma
 *
 */
public class ScaComponentWizardPage extends WizardPage {

	IWizard scaWizard;
	ScaComponentPageComposite composite;
	final static String BINDING_RMI = "RMI";
	final static String BINDING_WS = "WebService";
	final static String BINDING_NONE = "None";
	protected ScaComponentWizardPage(String pageName, IWizard wizard) {
		super(pageName);
		setTitle(ScaJavaResources.getString("wizard.project.generalpage.title"));
		setDescription("Create new sca java component");
		ImageDescriptor banner = ScaJavaResources.getImageDescriptor("wizban/sca_wiz.gif");
        setImageDescriptor(banner);
		scaWizard = wizard;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		composite = new ScaComponentPageComposite(parent, 
				SWT.NULL);
		this.setControl(composite);
		composite.txtCompName.addModifyListener(new TextModifyAdapter());
		composite.txtImpl.addModifyListener(new TextModifyAdapter());
		composite.txtInterface.addModifyListener(new InterfaceModifyAdapter());
		
		composite.cmbBinding.add(BINDING_NONE);
		composite.cmbBinding.add(BINDING_RMI);
		composite.cmbBinding.add(BINDING_WS);
		composite.cmbBinding.select(2);
		
		composite.txtPackage.setFocus();
		setPageComplete(false);
		
	}

	
	private boolean validatePage() {
		setMessage(null);
		setErrorMessage(null);
		if (composite.txtImpl.getText() == null
				|| composite.txtImpl.getText().equals("")) {
			setErrorMessage("Implementation class name can't be empty");
			return false;
		}
		if (Character.isLowerCase(
				composite.txtImpl.getText().charAt(0))) {
			setErrorMessage("Implementation class name should start with UpperCase character");
		}
		if (composite.txtCompName.getText() == null
				|| composite.txtCompName.getText().equals("")) {
			setErrorMessage("component name can't be empty");
			return false;
		}
		
        return true;
	}
	
	public String getComponentName() {
		return composite.txtCompName.getText();
	}
	
	public String getImplName() {
		return composite.txtImpl.getText();
	}
	
	public String getImplFullName() {
		String packageName = getPackage();
		if (packageName == null || packageName.equals("")) {
			return getImplName();
		}
		return packageName + "." + getImplName();
	}
	
	public String getInterfaceName() {
		return composite.txtInterface.getText();
	}
	
	public String getInterfaceFullName() {
		String packageName = getPackage();
		if (packageName == null || packageName.equals("")) {
			return getInterfaceName();
		}
		return packageName + "." + getInterfaceName();
	}
	
	public String getPackage() {
		return composite.txtPackage.getText();
	}
	
	public String getServiceName() {
		return composite.txtServiceName.getText();
		
	}
	
	public String getBindingType() {
		return composite.cmbBinding.getText();
	}
	
	public IWizardPage getNextPage() {
        if (scaWizard == null) {
			return null;
		}
        if (composite.cmbBinding.getText().equals(BINDING_RMI)) {
        	return scaWizard.getPage(ScaJavaProjectWizard.RMI_PAGE);
        } else if (composite.cmbBinding.getText().equals(BINDING_WS)) {
        	return scaWizard.getPage(ScaJavaProjectWizard.WS_PAGE);
        }
        return null;
    }
	
	class TextModifyAdapter implements ModifyListener {
		public void modifyText(ModifyEvent e) {
			setPageComplete(validatePage());
		}
	}
	
	class InterfaceModifyAdapter implements ModifyListener {
		public void modifyText(ModifyEvent e) {
			String infName = composite.txtInterface.getText();
			if (infName == null || infName.equals("")) {
				return;
			}
			char ch = infName.charAt(0);
			if (Character.isLowerCase(ch)) {
                infName = Character.toUpperCase(ch) + infName.substring(1);
                composite.txtInterface.setText(infName);
                //call append "" to force caret to go to the end again
                composite.txtInterface.append("");
			}
			composite.txtImpl.setText(infName + "Impl");
			composite.txtCompName.setText(infName + "Component");
			composite.txtServiceName.setText(infName + "Service");
		}
	}
	
}
