/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.sc.sca.java.tuscany.launchers;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;

import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtimeintegrator.IGeneratorTool;
import org.eclipse.stp.sc.sca.java.ScaJavaPlugin;
import org.eclipse.stp.sc.sca.java.extensions.IJavaLaunchConfigGenerator;
import org.eclipse.stp.sc.sca.java.preferences.ScaJavaPreferenceConstants;
import org.eclipse.stp.sc.sca.java.workspace.ScaWorkspaceManager;

public class JavaLaunchConfigGenerator  implements IJavaLaunchConfigurationConstants, 
    IJavaLaunchConfigGenerator, IGeneratorTool{
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JavaLaunchConfigGenerator.class);
    private static final String TUSCANY_KIT_PROPERTY = "tuscany.installDir";
    
    
    private static final String NAME_PREFIX = "sca_";
    
    private String configBaseName = null;
    private String projectName = null;
    private String jarFilePath = null;
    private String tuscanyKitDir = null;
    
    //interal variable to create the launch configuration
    private String programArgs = null;
    private String vmArgs = null;
    private String serverMainClassName = null;
    
    public JavaLaunchConfigGenerator() {
    }
    
    /**
     * create launch configuration for SCA java component project
     * @param project, the project
     * @param configBaseName, the component name
     */
    public void createScaComponentLaunchConfig(IProject project, String componentName) {
    	projectName = project.getName();
    	IPreferenceStore preferenceStore = ScaJavaPlugin.getDefault()
	        .getPreferenceStore();
    	tuscanyKitDir = preferenceStore.getString(ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);
    
    	IFile jarFile = ScaWorkspaceManager.getJarOutputFile(project);
    	jarFilePath = jarFile.getProjectRelativePath().toString();
    	configBaseName = componentName;
    	
		programArgs = jarFilePath;
		vmArgs = "-D" + TUSCANY_KIT_PROPERTY + "=" + tuscanyKitDir;

		LOG.debug("progamArgs: " + programArgs);
		LOG.debug("vmArgs: " + vmArgs);
		LOG.debug("server config projectName: " + projectName);
		this.createLaunchConfig(NAME_PREFIX + projectName);
	}

    private void createLaunchConfig(String id) {
        String launchConfigName = configBaseName + "_" + id;
        LOG.debug("run/debug config name: " + launchConfigName);

        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID_JAVA_APPLICATION);
        
        try {
            ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
            for (int i = 0; i < configurations.length; i++) {
                ILaunchConfiguration configuration = configurations[i];
                if (configuration.getName().equals(launchConfigName)) {
                    configuration.delete();
                    break;
                    
                }
            }

            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, launchConfigName);

            //set project name and main class
            workingCopy.setAttribute(ATTR_PROJECT_NAME, projectName);
            workingCopy.setAttribute(ATTR_MAIN_TYPE_NAME, serverMainClassName);
            workingCopy.setAttribute(ATTR_PROGRAM_ARGUMENTS, programArgs);
            workingCopy.setAttribute(ATTR_VM_ARGUMENTS, vmArgs);
            workingCopy.setAttribute("org.eclipse.jdt.debug.ui.INCLUDE_EXTERNAL_JARS", true);
            setupClassPath(workingCopy);
            //save the run config
            workingCopy.doSave();
        } catch (CoreException ex) {
            LOG.debug("Exception thrown trying to create run config");
        }
    }
    
    private void setupClassPath(ILaunchConfigurationWorkingCopy workingCopy)
			throws CoreException {
		String bootJarPath = tuscanyKitDir + File.separator + "bin"
				+ File.separator + "launcher.jar";
		ArrayList<String> arrayList = (ArrayList<String>) workingCopy
				.getAttribute(ATTR_CLASSPATH, new ArrayList());

		arrayList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
						+ "<runtimeClasspathEntry containerPath=\"JRE_LIB\" path=\"1\" type=\"3\"/>");
		arrayList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
						+ "<runtimeClasspathEntry id=\"org.eclipse.jdt.launching.classpathentry.defaultClasspath\">"
						+ "<memento project=\"" + projectName + "\"/>"
						+ "</runtimeClasspathEntry>");
		arrayList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
				+ "<runtimeClasspathEntry externalArchive=\"" + bootJarPath
				+ "\" path=\"3\" type=\"2\"/>");
		LOG.debug("set classpath to include license dir.");
		workingCopy.setAttribute(ATTR_DEFAULT_CLASSPATH, false);

		workingCopy.setAttribute(ATTR_CLASSPATH, arrayList);
	}

	public String getConfigBaseName() {
		return configBaseName;
	}

	public void setConfigBaseName(String configBaseName) {
		this.configBaseName = configBaseName;
	}

	public String getJarFilePath() {
		return jarFilePath;
	}

	public void setJarFilePath(String jarFilePath) {
		this.jarFilePath = jarFilePath;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getTuscanyKitDir() {
		return tuscanyKitDir;
	}

	public void setTuscanyKitDir(String tuscanyKitDir) {
		this.tuscanyKitDir = tuscanyKitDir;
	}

	public void setInitializationData(IConfigurationElement config, 
			String propertyName, Object data) throws CoreException {
			serverMainClassName = config.getAttribute(IJavaLaunchConfigGenerator.PROPERTY_MAIN_CLASS);;
	}

    public void run(IPath path, IProject project) throws CoreException {
        // TODO Auto-generated method stub
        Exception e = new Exception("need to implement this generator!!");
        e.printStackTrace();
        
    }

}
