/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/**
 * @author rcernich
 * 
 * Created on Feb 24, 2004
 */
public class EmptyContainerFilter extends ViewerFilter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ViewerFilter#select(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		boolean retVal;
		List filters;
		if (viewer == null) {
			filters = new ArrayList();
		}
		else {
			filters = new Vector(Arrays.asList(((StructuredViewer) viewer)
					.getFilters()));
			filters.remove(this);
		}
		if (element instanceof IContainer) {
			retVal = containerHasFiles(viewer, filters, (IContainer) element);
		}
		else {
			retVal = true;
		}
		return retVal;
	}

	private boolean containerHasFiles(Viewer viewer, List filters,
			IContainer container) {
		try {
			boolean retVal = false;
			IResource[] contents = container.members(true);
			List containers = new Vector(contents.length);
			for (int index = 0, count = contents.length; index < count
					&& !retVal; ++index) {
				if (!isFiltered(viewer, filters, container, contents[index])) {
					int resType = contents[index].getType();
					if (resType == IResource.FILE) {
						retVal = true;
					}
					else if (resType == IResource.FOLDER
							|| resType == IResource.PROJECT
							|| resType == IResource.ROOT) {
						containers.add(contents[index]);
					}
				}
			}
			for (Iterator it = containers.iterator(); it.hasNext() && !retVal;) {
				retVal = containerHasFiles(viewer, filters, (IContainer) it
						.next());
			}
			return retVal;
		}
		catch (CoreException e) {
			// eat it
			return false;
		}
	}

	private boolean isFiltered(Viewer viewer, List filters,
			IContainer container, IResource memeber) {
		boolean filtered = false;
		for (Iterator it = filters.iterator(); it.hasNext() && !filtered;) {
			ViewerFilter filter = (ViewerFilter) it.next();
			filtered = !filter.select(viewer, container, memeber);
		}
		return filtered;
	}

}
