/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.adapters;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.internal.deploy.core.cp.StpProfileManager;

/**
 * @author rcernich
 * 
 * Created on Jul 16, 2004
 */
public class DeployServerDeployAPIAdapter extends AdapterImpl implements
		IDeployAPIAdapter {

	public DeployServerDeployAPIAdapter() {
		super();
	}

	public boolean isAdapterForType(Object type) {
		return type == IDeployAPIAdapter.class;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asDeployTarget()
	 */
	public IDeployTarget asDeployTarget() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asLogicalPackage()
	 */
	public ILogicalPackage asLogicalPackage() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asPackage()
	 */
	public IPackage asPackage() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asPhysicalPackage()
	 */
	public IPhysicalPackage asPhysicalPackage() {
		return null;
	}

	public IConfigurablePackage asConfigurablePackage() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asConnectionProfile()
	 */
	public IConnectionProfile asConnectionProfile() {
		return StpProfileManager.getInstance().getProfileByName(
				((DeployServer) getTarget()).getProfileName());
	}

}