/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.cp;

import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.WTPServerBridge;

/**
 * This manager is based on ProfileManager from dtp connection profile.
 * Since the stp use connection profile defined from dtp and adapted from 
 * wtp server. We have this delegate class to retrive cp from dtp and wtp
 * bridge. All connection profile related actions should use the delegate 
 * class instead of directly use the ProfileManager defined in dtp
 * @author jma
 */
public class StpProfileManager extends ProfileManager {

	protected static StpProfileManager instance = null;
	
	public static StpProfileManager getInstance() {
		if (instance == null) {
			instance = new StpProfileManager();
		}
		return instance;
	}
	
	/**
	 * Get all connection profiles persisted in workspace
	 * 
	 * @return connection profiles
	 */
	public IConnectionProfile[] getProfiles() {
		ArrayList<IConnectionProfile> profiles = new ArrayList<IConnectionProfile>();
		for (IConnectionProfile pro : super.getProfiles()) {
			profiles.add(pro);
		}
		
		profiles.addAll(Arrays.asList(
				WTPServerBridge.getInstance().getProfiles()));
				
		return profiles.toArray(new IConnectionProfile[0]);
	}
	
	/**
	 * Get connection profiles by category
	 * @param catID
	 * @return IConnectionProfile[]
	 */
	public IConnectionProfile[] getProfilesByCategory(String catID) {
		ArrayList<IConnectionProfile> profiles = new ArrayList<IConnectionProfile>();
		profiles.addAll(Arrays.asList(super.getProfilesByCategory(catID)));
		
		profiles.addAll(Arrays.asList(
				WTPServerBridge.getInstance().getProfilesByCategory(catID)));

		return profiles.toArray(new IConnectionProfile[0]);
	}

	/**
	 * Get connection profile by name
	 * 
	 * @param name
	 * @return IConnectionProfile
	 */
	public IConnectionProfile getProfileByName(String name) {
		IConnectionProfile cp = super.getProfileByName(name);
		if (cp != null) {
			return cp;
		}
		//until here, the cp maybe get from wtp bridge
		return WTPServerBridge.getInstance().getProfileByName(name);
	}
	
	/**
	 * Get connection profile by instance ID
	 * 
	 * @param id
	 * @return IConnectionProfile
	 */
	public IConnectionProfile getProfileByInstanceID(String id) {
		System.err.println("pm:getProfileByInstanceID:" + id);
		return super.getProfileByInstanceID(id);
	}

	
	/**
	 * Get connection profiles by connection profile(cp) provider ID associated
	 * with each cp
	 * 
	 * @param ID
	 * @return IConnectionProfile[]
	 */
	public IConnectionProfile[] getProfileByProviderID(String ID) {
		return super.getProfileByProviderID(ID);
	}
	
	


	
	public ICategory[] getRootCategories() {
		ArrayList<ICategory> stpCat = new ArrayList<ICategory>();
		ICategory[] cats = super.getRootCategories();
		for (ICategory cat : cats) {
			//skip those profile categories defined in dtp
			if (cat.getId().equals(
					"org.eclipse.datatools.connectivity.oda.profileCategory")) {
				continue;
			} else if (cat.getId().equals(
					"org.eclipse.datatools.connectivity.db.category")) {
			    continue;	
			}
			stpCat.add(cat);
			
		}
		return stpCat.toArray(new ICategory[0]);
	}

		
}
