/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge;

import java.util.ArrayList;
import java.util.Hashtable;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;



/**
 * 
 * Bridge class between stp connection  profile based server and wtp servers
 * 
 * @author jma
 */

public class WTPServerBridge {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(WTPServerBridge.class);
	
	private static WTPServerBridge instance = null;
	
	/*
	 * holding all connection profile defined in extension registry
	 * Notice here, to match with wtp server type, we only use the last segment
	 * defined in connection profile id.
	 * for example, if the connection profile id is defined as 
	 * "org.eclipse.stp.soas.deploy.profile.tomcat", then the conntionProfileReg will has an entry as "tomcat"
	 */
	
	/**
	 * holding the server type and bridge ext mapping
	 */
	private Hashtable<String, WtpBridgeExtension> connectionProfileReg = new Hashtable<String, WtpBridgeExtension>();
	
	/**
	 * holding the server type and connection profile cat mapping
	 */
	private Hashtable<String, String> connectionCatReg = new Hashtable<String, String>();
	private Hashtable<String, IConnectionProfile> connectionProfileTab = new Hashtable<String, IConnectionProfile>();
	
	protected WTPServerBridge() {
		try {
	        loadConnectionProfileIDFromReg();
		} catch (Exception e) {
			LOG.error("error during create wtp server bridge", e);
			e.printStackTrace();
		}
	}
	
	public static WTPServerBridge getInstance() {
	    if (instance == null) {
	    	instance = new WTPServerBridge();
	    }
	    return instance;
	}
	
	public IConnectionProfile[] getConnectionProfile() {
	    return null;
	}
	
	public IConnectionProfile[] getProfiles() {
		return getProfilesByCategory(null);
	}
	
	
	public IConnectionProfile[] getProfilesByCategory(String catId) {
		LOG.debug("wtp bridge get profile by cat called:" + catId);
		ArrayList<IConnectionProfile> profiles = new ArrayList<IConnectionProfile>();
		try {
			IServer[] servers = ServerCore.getServers();
			for (IServer server : servers) {
				IServerType type = server.getServerType();
				String connectionCat = getConnectionCatByServerType(type
						.getId());
				if (catId != null && !connectionCat.equals(catId)) {
					continue;
				}
				String connectionProfileProvider = getConnectionProfileByServerType(type
						.getId());
				if (connectionProfileProvider != null) {
					WtpBridgeExtension ext = connectionProfileReg.get(type.getId());
					IConnectionProfile wtpAdapter = ServerAdapterFactory
							.createWTPServerAdapter(server,
					        connectionProfileProvider, 
						    ext);
					connectionProfileTab.put(wtpAdapter.getName(), wtpAdapter);
					profiles.add(wtpAdapter);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		LOG.debug("profiles from wtp:" + profiles.size());
		return profiles.toArray(new IConnectionProfile[0]);
		
	}
	
	public IConnectionProfile getProfileByName(String name){
		return connectionProfileTab.get(name);
	}
	
	private String getConnectionProfileByServerType(String typeID) {
		return connectionProfileReg.get(typeID).connectionProfileID;
	}
	
	private String getConnectionCatByServerType(String typeID) {
		return connectionCatReg.get(typeID);
	}
	
	/**
	 * get all defined connection profile extensions from the extension point registry
	 * @return
	 * @throws CoreException 
	 */
	private void loadConnectionProfileIDFromReg() throws CoreException {
		IExtensionPoint exp = Platform.getExtensionRegistry()
	        .getExtensionPoint("org.eclipse.stp.soas.deploy.core.wtpBridge");
	    IExtension[] exts = exp.getExtensions();
	    for (IExtension ext : exts) {
		    IConfigurationElement[] cfgs = ext.getConfigurationElements();
		    for (IConfigurationElement cfg : cfgs) {
		    	if (cfg.getName().equals("serverTypeMap")) {
		    	    String serverType = cfg.getAttribute("wtpServerType");
		    	    String cpID = cfg.getAttribute("stpConnectionProfile");
		    	    System.err.println("cpID:" + cpID);
		    	    String catID = cfg.getAttribute("stpProfileCatetory");
		    	    WtpBridgeExtension wtpExt = 
		    	    	new WtpBridgeExtension(serverType,
		    	    			cpID,
		    	    			cfg);
		    	    connectionProfileReg.put(serverType, 
		    	    		wtpExt);
		    	    connectionCatReg.put(serverType, catID);
		    	    
		        }
		    }
	    }
	
		
	}
}
