package org.eclipse.stp.soas.internal.deploy.ui.views;

import java.util.Properties;

import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.internal.ui.CCOverLayIconUtility;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

import com.ibm.icu.text.MessageFormat;

/**
 * @author rcernich, brianf
 */
public class ConnectionProfileLabelProvider extends LabelProvider implements
		ICommonLabelProvider {

	public ConnectionProfileLabelProvider() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) {
		Image image;
		if (element instanceof ICategory) {
			image = PlatformUI.getWorkbench().getSharedImages().getImage(
					ISharedImages.IMG_OBJ_FOLDER);
		}
		else if (element instanceof IConnectionProfile) {
			IConnectionProfile profile = (IConnectionProfile) element;
			image = ProfileImageRegistry.getInstance().getProfileImage(
					profile.getProvider());
			if (profile.isConnected()) {
				ImageRegistry registry = DSEPlugin.getDefault()
						.getImageRegistry();
				image = registry.get(profile.getName().concat(
						SharedImages.IMAGE_RUNNING));
				if (image == null) {
					image = CCOverLayIconUtility.getDefault().addOverlayIcon(
							ProfileImageRegistry.getInstance().getProfileImage(
									profile.getProvider()),
							CCOverLayIconUtility.RUNNING);
					registry.put(profile.getName().concat(
							SharedImages.IMAGE_RUNNING), image);
				}
			}
		}
		else {
			image = null;
		}
		return image;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) {
		String text = null;
		if (element instanceof ICategory) {
			text = ((ICategory) element).getName();
		}
		else if (element instanceof IConnectionProfile) {
			IConnectionProfile profile = (IConnectionProfile) element;
			StringBuffer sb = new StringBuffer(profile.getName());
			if (profile.isConnected()) {
				Properties props = profile
						.getProperties(ConnectionProfileConstants.VERSION_INFO_PROFILE_EXTENSION_ID);
				String serverName = props
						.getProperty(ConnectionProfileConstants.PROP_SERVER_NAME);
				Version serverVersion = Version
						.valueOf(props
								.getProperty(ConnectionProfileConstants.PROP_SERVER_VERSION));
				if ((serverName != null && serverName.length() > 0)
						|| serverVersion != Version.NULL_VERSION) {
					String versionStr = MessageFormat
							.format(
									ConnectivityUIPlugin
											.getDefault()
											.getResourceString(
													"CommonLabelProviderBase.label.version"),
									new String[] { profile.getName(),
											serverName,
											serverVersion.toString()});

					sb = new StringBuffer(versionStr);
				}
			}
			text = sb.toString();
		}
		else {
			text = super.getText(element);
		}
		return text;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		super.dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.ICommonLabelProvider#init(org.eclipse.ui.navigator.IExtensionStateModel,
	 *      org.eclipse.jface.viewers.ITreeContentProvider)
	 */
	public void init(IExtensionStateModel aStateModel,
			ITreeContentProvider aContentProvider) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.IMementoAware#restoreState(org.eclipse.ui.IMemento)
	 */
	public void restoreState(IMemento aMemento) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.IMementoAware#saveState(org.eclipse.ui.IMemento)
	 */
	public void saveState(IMemento aMemento) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.IDescriptionProvider#getDescription(java.lang.Object)
	 */
	public String getDescription(Object element) {
		String desc;
		if (element instanceof ICategory) {
			desc = ((ICategory) element).getName();
		}
		else if (element instanceof IConnectionProfile) {
			IConnectionProfile profile = (IConnectionProfile) element;
			Properties props = profile.getBaseProperties();
			String serverName = props
					.getProperty(ConnectionProfileConstants.PROP_SERVER_NAME);
			Version serverVersion = Version
					.valueOf(props
							.getProperty(ConnectionProfileConstants.PROP_SERVER_VERSION));
			if ((serverName != null && serverName.length() > 0)
					|| serverVersion != Version.NULL_VERSION) {
				desc = MessageFormat.format(ConnectivityUIPlugin.getDefault()
						.getResourceString(
								"CommonLabelProviderBase.label.version"),
						new String[] { profile.getName(), serverName,
								serverVersion.toString()});

			}
			else {
				desc = profile.getName();
			}
		}
		else {
			desc = null;
		}
		return desc;
	}

	public void init(ICommonContentExtensionSite aConfig) {
	}
}