/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.ArtifactsContainer;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;

public class BpmnDiagramCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    private Collection myLinkDescriptors = new LinkedList();
    private Map myEObject2ViewMap = new HashMap();

    protected List getSemanticChildrenList() {
        int nodeVID;
        LinkedList<EObject> result = new LinkedList<EObject>();
        EObject modelObject = ((View)this.getHost().getModel()).getElement();
        View viewObject = (View)this.getHost().getModel();
        for (EObject nextValue : ((BpmnDiagram)modelObject).getPools()) {
            nodeVID = BpmnVisualIDRegistry.getNodeVisualID(viewObject, nextValue);
            if (1001 != nodeVID) continue;
            result.add(nextValue);
        }
        for (EObject nextValue : ((ArtifactsContainer)modelObject).getArtifacts()) {
            nodeVID = BpmnVisualIDRegistry.getNodeVisualID(viewObject, nextValue);
            switch (nodeVID) {
                case 1002: {
                    result.add(nextValue);
                    break;
                }
                case 1003: {
                    result.add(nextValue);
                    break;
                }
                case 1004: {
                    result.add(nextValue);
                }
            }
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return view.isSetElement() && view.getElement() != null && view.getElement().eIsProxy();
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Collection refreshConnections() {
        try {
            this.collectAllLinks((View)this.getDiagram());
            LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
            Iterator diagramLinks = existingLinks.iterator();
            while (diagramLinks.hasNext()) {
                Edge nextDiagramLink = (Edge)diagramLinks.next();
                EObject diagramLinkObject = nextDiagramLink.getElement();
                EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
                EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
                int diagramLinkVisualID = BpmnVisualIDRegistry.getVisualID((View)nextDiagramLink);
                Iterator modelLinkDescriptors = this.myLinkDescriptors.iterator();
                while (modelLinkDescriptors.hasNext()) {
                    LinkDescriptor nextLinkDescriptor = (LinkDescriptor)modelLinkDescriptors.next();
                    if (diagramLinkObject != nextLinkDescriptor.getLinkElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                    diagramLinks.remove();
                    modelLinkDescriptors.remove();
                }
            }
            this.deleteViews(existingLinks.iterator());
            Collection collection = this.createConnections(this.myLinkDescriptors);
            return collection;
        }
        finally {
            this.myLinkDescriptors.clear();
            this.myEObject2ViewMap.clear();
        }
    }

    private void collectAllLinks(View view) {
        EObject modelElement = view.getElement();
        int diagramElementVisualID = BpmnVisualIDRegistry.getVisualID(view);
        switch (diagramElementVisualID) {
            case 79: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: {
                this.myEObject2ViewMap.put(modelElement, view);
                this.storeLinks(modelElement, this.getDiagram());
            }
        }
        for (View childView : view.getChildren()) {
            this.collectAllLinks(childView);
        }
    }

    private Collection createConnections(Collection linkDescriptors) {
        if (linkDescriptors.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (LinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPartFor(nextLinkDescriptor.getSource());
            EditPart targetEditPart = this.getEditPartFor(nextLinkDescriptor.getDestination());
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPartFor(EObject modelElement) {
        View view = (View)this.myEObject2ViewMap.get(modelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private void storeLinks(EObject container, Diagram diagram) {
        EClass containerMetaclass = container.eClass();
        this.storeFeatureModelFacetLinks(container, containerMetaclass, diagram);
        this.storeTypeModelFacetLinks(container, containerMetaclass);
    }

    private void storeTypeModelFacetLinks(EObject container, EClass containerMetaclass) {
        EObject src;
        EObject dst;
        Vertex structuralFeatureResult;
        int linkVID;
        if (BpmnPackage.eINSTANCE.getGraph().isSuperTypeOf(containerMetaclass)) {
            for (EObject nextValue : ((Graph)container).getSequenceEdges()) {
                linkVID = BpmnVisualIDRegistry.getLinkWithClassVisualID(nextValue);
                if (3001 != linkVID || !((structuralFeatureResult = ((SequenceEdge)nextValue).getTarget()) instanceof EObject)) continue;
                dst = (EObject)structuralFeatureResult;
                structuralFeatureResult = ((SequenceEdge)nextValue).getSource();
                if (!(structuralFeatureResult instanceof EObject)) continue;
                src = (EObject)structuralFeatureResult;
                this.myLinkDescriptors.add(new LinkDescriptor(src, dst, nextValue, linkVID));
            }
        }
        if (BpmnPackage.eINSTANCE.getBpmnDiagram().isSuperTypeOf(containerMetaclass)) {
            for (EObject nextValue : ((BpmnDiagram)container).getMessages()) {
                linkVID = BpmnVisualIDRegistry.getLinkWithClassVisualID(nextValue);
                if (3002 != linkVID || !((structuralFeatureResult = ((MessagingEdge)nextValue).getTarget()) instanceof EObject)) continue;
                dst = (EObject)structuralFeatureResult;
                structuralFeatureResult = ((MessagingEdge)nextValue).getSource();
                if (!(structuralFeatureResult instanceof EObject)) continue;
                src = (EObject)structuralFeatureResult;
                this.myLinkDescriptors.add(new LinkDescriptor(src, dst, nextValue, linkVID));
            }
        }
        if (BpmnPackage.eINSTANCE.getArtifact().isSuperTypeOf(containerMetaclass)) {
            for (EObject nextValue : ((Artifact)container).getAssociations()) {
                linkVID = BpmnVisualIDRegistry.getLinkWithClassVisualID(nextValue);
                if (3003 != linkVID || !((structuralFeatureResult = ((Association)nextValue).getTarget()) instanceof EObject)) continue;
                dst = (EObject)structuralFeatureResult;
                structuralFeatureResult = ((Association)nextValue).getSource();
                if (!(structuralFeatureResult instanceof EObject)) continue;
                src = (EObject)structuralFeatureResult;
                this.myLinkDescriptors.add(new LinkDescriptor(src, dst, nextValue, linkVID));
            }
        }
    }

    private void storeFeatureModelFacetLinks(EObject container, EClass containerMetaclass, Diagram diagram) {
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private class LinkDescriptor {
        private EObject mySource;
        private EObject myDestination;
        private EObject myLinkElement;
        private int myVisualID;
        private IAdaptable mySemanticAdapter;

        protected LinkDescriptor(EObject source, EObject destination, EObject linkElement, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = linkElement;
            this.mySemanticAdapter = new EObjectAdapter(linkElement);
        }

        protected LinkDescriptor(EObject source, EObject destination, IElementType elementType, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = null;
            final IElementType elementTypeCopy = elementType;
            this.mySemanticAdapter = new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (IElementType.class.equals((Object)adapter)) {
                        return elementTypeCopy;
                    }
                    return null;
                }
            };
        }

        private LinkDescriptor(EObject source, EObject destination, int linkVID) {
            this.mySource = source;
            this.myDestination = destination;
            this.myVisualID = linkVID;
        }

        protected EObject getSource() {
            return this.mySource;
        }

        protected EObject getDestination() {
            return this.myDestination;
        }

        protected EObject getLinkElement() {
            return this.myLinkElement;
        }

        protected int getVisualID() {
            return this.myVisualID;
        }

        protected IAdaptable getSemanticAdapter() {
            return this.mySemanticAdapter;
        }
    }
}

