/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.IdentifiableNode;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.stp.bpmn.handles.ConnectionHandleEx;
import org.eclipse.stp.bpmn.handles.ConnectionHandleForAssociation;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.MessageConnectionValidator;

public class ConnectionHandleEditPolicyEx
extends DiagramAssistantEditPolicy {
    private OwnerMovedListener ownerMovedListener = new OwnerMovedListener();
    private List handles = null;

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof ConnectionHandle;
    }

    protected List getHandleFigures() {
        EObject semanticElement;
        ArrayList<ConnectionHandleEx> list = new ArrayList<ConnectionHandleEx>(3);
        String tooltip = this.buildTooltip(ConnectionHandle.HandleDirection.INCOMING);
        if (tooltip != null) {
            list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, tooltip));
        }
        if ((tooltip = this.buildTooltip(ConnectionHandle.HandleDirection.OUTGOING)) != null) {
            list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, tooltip));
        }
        if ((semanticElement = ((GraphicalEditPart)this.getHost()).getNotationView().getElement()) instanceof Artifact) {
            list.add(new ConnectionHandleForAssociation((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, "Association"));
        } else if (semanticElement instanceof IdentifiableNode) {
            list.add(new ConnectionHandleForAssociation((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, "Association"));
        }
        return list;
    }

    protected String buildTooltip(ConnectionHandle.HandleDirection direction) {
        boolean supportsSRE;
        boolean supportsCreation;
        ModelingAssistantService service = ModelingAssistantService.getInstance();
        boolean bl = direction == ConnectionHandle.HandleDirection.OUTGOING ? !service.getRelTypesOnSource((IAdaptable)this.getHost()).isEmpty() : (supportsCreation = !service.getRelTypesOnTarget((IAdaptable)this.getHost()).isEmpty());
        boolean bl2 = direction == ConnectionHandle.HandleDirection.OUTGOING ? !service.getRelTypesForSREOnSource((IAdaptable)this.getHost()).isEmpty() : (supportsSRE = !service.getRelTypesForSREOnTarget((IAdaptable)this.getHost()).isEmpty());
        if (supportsSRE) {
            if (supportsCreation) {
                return DiagramUIMessages.ConnectionHandle_ToolTip_ShowRelatedElementsAndCreateRelationship;
            }
            return DiagramUIMessages.ConnectionHandle_ToolTip_ShowRelatedElementsOnly;
        }
        if (supportsCreation) {
            return DiagramUIMessages.ConnectionHandle_ToolTip_CreateRelationshipOnly;
        }
        return null;
    }

    public void activate() {
        super.activate();
        ((IGraphicalEditPart)this.getHost()).getFigure().addFigureListener((FigureListener)this.ownerMovedListener);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeFigureListener((FigureListener)this.ownerMovedListener);
        super.deactivate();
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (referencePoint == null) {
            referencePoint = this.getHostFigure().getBounds().getRight();
        }
        this.handles = this.getHandleFigures();
        if (this.handles == null) {
            return;
        }
        ConnectionHandleLocator locator = this.getConnectionHandleLocator(referencePoint);
        EdgeConnectionValidator edgeValidator = new EdgeConnectionValidator();
        MessageConnectionValidator messageValidator = new MessageConnectionValidator();
        EditPart host = this.getHost();
        if (host instanceof ActivityEditPart) {
            ((ActivityEditPart)host).setHandlePosition(locator.getBorderSide());
        }
        if (locator.getBorderSide() == 16) {
            this.handles.remove(0);
            if (!edgeValidator.canStart(this.getHost())) {
                this.handles.removeAll(this.handles);
            }
        } else if (locator.getBorderSide() == 8) {
            this.handles.remove(1);
            if (!edgeValidator.canEnd(this.getHost())) {
                this.handles.removeAll(this.handles);
            }
        } else if (locator.getBorderSide() == 1 || locator.getBorderSide() == 4) {
            if (!messageValidator.canStart(this.getHost())) {
                this.handles.remove(1);
            }
            if (!messageValidator.canEnd(this.getHost())) {
                this.handles.remove(0);
            }
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (ConnectionHandle handle : this.handles) {
            handle.setLocator((Locator)locator);
            locator.addHandle(handle);
            handle.addMouseMotionListener((MouseMotionListener)this);
            layer.add((IFigure)handle);
            this.getHost().getViewer().getVisualPartMap().put(handle, this.getHost());
        }
        if (!this.shouldAvoidHidingDiagramAssistant()) {
            this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
        }
    }

    protected boolean isPreferenceOn() {
        String prefName = this.getThePreferenceName();
        if (prefName == null) {
            return true;
        }
        IPreferenceStore preferenceStore = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
        return preferenceStore.getBoolean(prefName);
    }

    protected String getThePreferenceName() {
        return "Global.showConnectionHandles";
    }

    protected void hideDiagramAssistant() {
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (IFigure handle : this.handles) {
            handle.removeMouseMotionListener((MouseMotionListener)this);
            layer.remove(handle);
            this.getHost().getViewer().getVisualPartMap().remove(handle);
        }
        this.handles = null;
        EditPart host = this.getHost();
        if (host instanceof ActivityEditPart) {
            ((ActivityEditPart)host).setHandlePosition(0);
        }
    }

    private boolean isSelectionToolActive() {
        Tool theTool;
        return this.getHost().getParent() != null && (theTool = this.getHost().getViewer().getEditDomain().getActiveTool()) != null && theTool instanceof SelectionTool;
    }

    protected boolean shouldShowDiagramAssistant() {
        if (this.getAppearanceDelay() < 0) {
            return false;
        }
        if (!super.shouldShowDiagramAssistant()) {
            return false;
        }
        return this.handles == null && this.isSelectionToolActive();
    }

    protected ConnectionHandleLocator getConnectionHandleLocator(Point referencePoint) {
        return new ConnectionHandleLocator(this.getHostFigure(), referencePoint);
    }

    protected boolean isDiagramAssistantShowing() {
        return this.handles != null;
    }

    protected int getAppearanceDelay() {
        IPreferenceStore preferenceStore = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
        int delay = preferenceStore.getInt(BpmnDiagramPreferenceInitializer.PREF_CONN_DIAG_ASSISTANT_DELAY_MS);
        return delay > -1 ? delay : 60;
    }

    private class OwnerMovedListener
    implements FigureListener {
        private OwnerMovedListener() {
        }

        public void figureMoved(IFigure source) {
            ConnectionHandleEditPolicyEx.this.hideDiagramAssistant();
        }
    }
}

