/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.samples.bpel2bpmn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.generation.impl.BPMNVisual2ProcessGenerator;
import org.eclipse.stp.bpmn.samples.SamplesPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPEL2BPMNGenerator
extends BPMNVisual2ProcessGenerator {
    private static Set<String> PARSED_BPEL_LOCAL_NAME = new HashSet<String>();
    private static Set<String> CONTAINERS_LOCAL_NAME = new HashSet<String>();
    public static final String NAMESPACES_SAXF = "http://xml.org/sax/features/namespaces";
    private EObject _currentSemanticElement;
    private Pool _virtualPool;
    private IFile _file;
    private Locator _locator;

    static {
        CONTAINERS_LOCAL_NAME.add("scope");
        CONTAINERS_LOCAL_NAME.add("flow");
        PARSED_BPEL_LOCAL_NAME.add("assign");
        PARSED_BPEL_LOCAL_NAME.add("receive");
        PARSED_BPEL_LOCAL_NAME.add("reply");
        PARSED_BPEL_LOCAL_NAME.add("invoke");
        PARSED_BPEL_LOCAL_NAME.addAll(CONTAINERS_LOCAL_NAME);
    }

    public BPEL2BPMNGenerator(IFile file) {
        this._file = file;
    }

    public List<View> parseAndGenerateFromFile() {
        try {
            this._virtualPool = this.addPool("nonCopiedPool");
            XMLReader saxReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            saxReader.setFeature(NAMESPACES_SAXF, true);
            saxReader.setContentHandler(new BPELSimpleContentHandler());
            saxReader.parse(new InputSource(this._file.getContents()));
            this.generateViews();
            ArrayList<View> res = new ArrayList<View>();
            Map sem2views = this.getSemantic2notationMap();
            for (Object overtex : this._virtualPool.getVertices()) {
                res.add((View)sem2views.get(overtex));
            }
            for (Object overtex : this._virtualPool.getSequenceEdges()) {
                res.add((View)sem2views.get(overtex));
            }
            return res;
        }
        catch (SAXParseException e) {
            SamplesPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.samples", 4, this._file + " lineNb=" + e.getLineNumber() + " - " + e.getMessage(), (Throwable)e));
        }
        catch (SAXException e) {
            SamplesPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.samples", 4, e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            SamplesPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.samples", 4, e.getMessage(), (Throwable)e));
        }
        catch (CoreException e) {
            SamplesPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.samples", 4, e.getMessage(), (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            SamplesPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.samples", 4, e.getMessage(), (Throwable)e));
        }
        return null;
    }

    private Graph getParentNode(String currentLocalName, String name) throws SAXParseException {
        Activity cu;
        if (this._currentSemanticElement == null) {
            return this._virtualPool;
        }
        if (this._currentSemanticElement instanceof Graph) {
            return (Graph)this._currentSemanticElement;
        }
        if (this._currentSemanticElement instanceof Activity && (cu = (Activity)this._currentSemanticElement).getActivityType().getValue() == 28) {
            return cu.getGraph();
        }
        throw new SAXParseException("Expecting to be inside a container to add a " + currentLocalName + (name != null ? " name='" + name : "'") + " but is inside " + this._currentSemanticElement, this._locator);
    }

    private void connectPredecessor(Graph parentNode, Vertex newlyCreatedChild) throws SAXParseException {
        Vertex predecessor = null;
        for (Object v : parentNode.getVertices()) {
            Vertex currentChild = (Vertex)v;
            if (newlyCreatedChild == currentChild) {
                if (predecessor == null) break;
                this.addSequenceEdge(predecessor, newlyCreatedChild, "");
                break;
            }
            if (!(currentChild instanceof Vertex)) continue;
            predecessor = currentChild;
        }
    }

    private Activity addActivity(String bpelLocalName, String name, int type) throws SAXParseException {
        Graph parentNode = this.getParentNode(bpelLocalName, name);
        Activity newActivity = this.addActivity(parentNode, name, type);
        this.createLinkAnnotation((EModelElement)newActivity, this._locator);
        this.connectPredecessor(parentNode, (Vertex)newActivity);
        this._currentSemanticElement = newActivity;
        return newActivity;
    }

    private void createLinkAnnotation(EModelElement semanticElement, Locator locator) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("projectRelativePath", this._file.getProjectRelativePath().toString());
        details.put("lineNumber", String.valueOf(locator.getLineNumber()));
        this.addAnnotation(semanticElement, "genericFile", details);
    }

    private class BPELSimpleContentHandler
    implements ContentHandler {
        private BPELSimpleContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            BPEL2BPMNGenerator.this._locator = locator;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (!PARSED_BPEL_LOCAL_NAME.contains(localName)) {
                return;
            }
            if (BPEL2BPMNGenerator.this._currentSemanticElement == null) {
                throw new SAXParseException("No more containers in the semantic model. We are at </" + localName + ">. Not sure what to do.", BPEL2BPMNGenerator.this._locator);
            }
            BPEL2BPMNGenerator.this._currentSemanticElement = BPEL2BPMNGenerator.this._currentSemanticElement.eContainer();
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if (!PARSED_BPEL_LOCAL_NAME.contains(localName)) {
                return;
            }
            String bpelName = atts.getValue("name");
            if ("scope".equals(localName)) {
                BPEL2BPMNGenerator.this.addActivity(localName, bpelName, 1);
            } else if ("flow".equals(localName)) {
                BPEL2BPMNGenerator.this.addActivity(localName, bpelName, 28);
            } else if ("assign".equals(localName)) {
                BPEL2BPMNGenerator.this.addActivity("assign", bpelName, 0);
            } else if ("receive".equals(localName)) {
                if (name == null) {
                    name = "Receive";
                } else if (name.toLowerCase().indexOf("receive") == -1) {
                    name = "Receive " + bpelName;
                }
                BPEL2BPMNGenerator.this.addActivity(localName, name, 9);
            } else if ("reply".equals(localName)) {
                if (name == null) {
                    name = "Reply";
                } else if (name.toLowerCase().indexOf("receive") == -1) {
                    name = "Reply " + bpelName;
                }
                BPEL2BPMNGenerator.this.addActivity(localName, bpelName, 9);
            } else if ("invoke".equals(localName)) {
                if (name == null) {
                    name = "Invoke";
                } else if (name.toLowerCase().indexOf("receive") == -1) {
                    name = "Invoke " + bpelName;
                }
                BPEL2BPMNGenerator.this.addActivity(localName, bpelName, 0);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

