/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceHandler;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;

public class ProjectResourceSetEditImpl
extends ResourceSetImpl
implements ProjectResourceSet {
    private final IProject project;
    private final List resourceHandlers = new ArrayList();
    private ResourceSetWorkbenchSynchronizer synchronizer;
    private boolean released = false;

    protected ProjectResourceSetEditImpl() {
        this.init();
        this.project = null;
    }

    public ProjectResourceSetEditImpl(IProject aProject) {
        this.init();
        Assert.isNotNull(aProject);
        Assert.isTrue(aProject.isAccessible());
        this.project = aProject;
        this.initializeSharedCacheListener();
    }

    private void init() {
        this.setURIResourceMap(new HashMap(10));
        this.getLoadOptions().put("USE_PARSER_POOL", EMFNature.SHARED_PARSER_POOL);
    }

    public Resource createResource(URI uri) {
        Assert.isTrue(!this.released);
        URIConverterImpl.URIMap uriMap = (URIConverterImpl.URIMap)this.getURIConverter().getURIMap();
        URI mappedURI = uriMap.getURI(uri);
        boolean isMapped = mappedURI == null || !mappedURI.equals((Object)uri);
        URI converted = isMapped ? this.getURIConverter().normalize(uri) : uri;
        Resource result = this.createResourceFromHandlers(converted);
        if (result == null) {
            result = super.createResource(converted);
        }
        if (result != null && WorkbenchResourceHelper.isReferencedResource(result)) {
            WorkbenchResourceHelper.cacheSynchronizationStamp((ReferencedResource)result);
        }
        return result;
    }

    public IProject getProject() {
        return this.project;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        Assert.isTrue(!this.released);
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        EObject result = null;
        if (resource != null && resource.isLoaded()) {
            result = resource.getEObject(uri.fragment());
        }
        if (result == null) {
            result = this.getEObjectFromHandlers(uri, loadOnDemand);
        }
        return result;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Assert.isTrue(!this.released);
        return super.getResource(uri, loadOnDemand);
    }

    public boolean add(ResourceHandler resourceHandler) {
        Assert.isTrue(!this.released);
        return this.resourceHandlers.add(resourceHandler);
    }

    public void addFirst(ResourceHandler resourceHandler) {
        Assert.isTrue(!this.released);
        this.resourceHandlers.add(0, resourceHandler);
    }

    public boolean remove(ResourceHandler resourceHandler) {
        Assert.isTrue(!this.released);
        return this.resourceHandlers.remove(resourceHandler);
    }

    public ResourceSetWorkbenchSynchronizer getSynchronizer() {
        Assert.isTrue(!this.released);
        return this.synchronizer;
    }

    public void setSynchronizer(ResourceSetWorkbenchSynchronizer aSynchronizer) {
        Assert.isTrue(!this.released);
        Assert.isTrue(this.synchronizer == null);
        this.synchronizer = aSynchronizer;
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry factoryReg) {
        Assert.isTrue(!this.released);
        if (this.resourceFactoryRegistry != null && factoryReg != null) {
            this.preserveEntries(factoryReg.getExtensionToFactoryMap(), this.resourceFactoryRegistry.getExtensionToFactoryMap());
            this.preserveEntries(factoryReg.getProtocolToFactoryMap(), this.resourceFactoryRegistry.getProtocolToFactoryMap());
        }
        super.setResourceFactoryRegistry(factoryReg);
    }

    public void resetNormalizedURICache() {
        Assert.isTrue(!this.released);
        if (this.getURIResourceMap() != null) {
            this.getURIResourceMap().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ProjectResourceSetEditImpl projectResourceSetEditImpl = this;
        synchronized (projectResourceSetEditImpl) {
            if (this.released) {
                return;
            }
            this.released = true;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new NotificationImpl(14, null, null, -1, false){

                    public int getFeatureID(Class expectedClass) {
                        return 1000;
                    }

                    public Object getNotifier() {
                        return ProjectResourceSetEditImpl.this;
                    }
                });
            }
            if (this.synchronizer != null) {
                this.synchronizer.dispose();
            }
            this.synchronizer = null;
            this.removeAndUnloadAllResources();
            if (this.resourceHandlers != null) {
                this.resourceHandlers.clear();
            }
            if (this.eAdapters != null) {
                this.eAdapters.clear();
            }
            JEMUtilPlugin.getSharedCache().stopListening((ProjectResourceSet)this);
        }
    }

    protected void removeAndUnloadAllResources() {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        int size = this.resources.size();
        int i = 0;
        while (i < size) {
            Resource res = (Resource)this.resources.get(i);
            try {
                res.unload();
            }
            catch (RuntimeException ex) {
                EMFInfrastructurePlugin.logError(0, ex.getMessage(), ex);
            }
            ++i;
        }
        this.resources.clear();
    }

    protected void initializeSharedCacheListener() {
        JEMUtilPlugin.getSharedCache().beginListening((ProjectResourceSet)this);
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        Assert.isTrue(!this.released);
        Resource res = super.delegatedGetResource(uri, loadOnDemand);
        if (res == null) {
            res = this.getResourceFromHandlers(uri);
        }
        return res;
    }

    protected void demandLoad(Resource resource) throws IOException {
        Assert.isTrue(!this.released);
        super.demandLoad(resource);
    }

    protected Resource createResourceFromHandlers(URI uri) {
        Assert.isTrue(!this.released);
        Resource resource = null;
        ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (ResourceHandler)this.resourceHandlers.get(i);
            resource = handler.createResource((ResourceSet)this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    protected Resource getResourceFromHandlers(URI uri) {
        Assert.isTrue(!this.released);
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            Resource resource = ((ResourceHandler)this.resourceHandlers.get(i)).getResource((ResourceSet)this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    protected EObject getEObjectFromHandlers(URI uri, boolean loadOnDemand) {
        EObject obj = null;
        ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (ResourceHandler)this.resourceHandlers.get(i);
            obj = handler.getEObjectFailed((ResourceSet)this, uri, loadOnDemand);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected void preserveEntries(Map map1, Map map2) {
        if (map2.isEmpty()) {
            return;
        }
        for (Map.Entry entry : map2.entrySet()) {
            if (map1.containsKey(entry.getKey())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
    }
}

