/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.introspection;

import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.resources.CompositeScribblerDomain;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.tests.introspection.AssertNotificationAdapter;
import org.eclipse.stp.core.tests.introspection.PropertiesSharedModel;
import org.eclipse.stp.core.tests.util.TestWorkspace;

public class ComponentTypeIntrospectionTests
extends TestCase {
    private static final String ORG_ACME_TEST_INTERFACE = "org.acme.TestInterface";
    private static final String EXPECTED_PROP_TYPE_VALUE = "java.lang.String";
    private static final boolean EXPECTED_PROP_REQUIRED_VALUE = false;
    private static final String EXPECTED_PROPERTY_NAME = "SimpleProperty";
    private static final String EXPECTED_REFERENCE_NAME = "SimpleReference";
    private static final String EXPECTED_SERVICE_NAME = "SimpleService";
    private IProject testProject;
    private IFile compositeFile;
    private IFile componentTypeFile;
    private IFile propertyComponentTypeFile;
    private SCAFactory factory = SCAPackage.eINSTANCE.getSCAFactory();

    public ComponentTypeIntrospectionTests(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ComponentTypeIntrospectionTests.class);
        return suite;
    }

    protected void setUp() throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe method add(EObject) in the type List<EObject> is not applicable for the arguments (SCACoreRoot)\n");
    }

    private void setUpComponentTypeFile() {
        throw new Error("Unresolved compilation problem: \n\tThe method add(EObject) in the type List<EObject> is not applicable for the arguments (SCACoreRoot)\n");
    }

    protected void tearDown() throws Exception {
        TestWorkspace.getComponentTypeIntrospectorTestProject().delete(true, null);
    }

    public void testComponentTypeIntrospectionServices() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        AssertNotificationAdapter assertAdapter = new AssertNotificationAdapter();
        componentType.getEObject().eAdapters().add((Object)assertAdapter);
        List services = componentType.getServices();
        assertAdapter.assertNoNotifications("No notifications should be generated when fetching services for the first time.");
        componentType.getEObject().eAdapters().remove((Object)assertAdapter);
        ComponentTypeIntrospectionTests.assertTrue((services.size() > 0 ? 1 : 0) != 0);
        Service service = (Service)services.get(0);
        ComponentTypeIntrospectionTests.assertEquals((String)"The service name should match the expected value.", (String)EXPECTED_SERVICE_NAME, (String)service.getName());
        ComponentTypeIntrospectionTests.assertTrue((String)"The service should have a Java Interface.", (boolean)(service.getInterface() instanceof JavaInterface));
        JavaInterface jifze = (JavaInterface)service.getInterface();
        ComponentTypeIntrospectionTests.assertEquals((String)"The Java interface should be the expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)jifze.getInterface());
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionServices_PushSynchronization() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        Service service1 = this.createService("PushedService1");
        Service service2 = this.createService("PushedService2");
        componentType.getServices().add(service1);
        componentType.getServices().add(service2);
        PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        String pushedInterface1 = props.getProperty(PropertiesSharedModel.serviceKey("PushedService1"));
        ComponentTypeIntrospectionTests.assertNotNull((String)"A service should have been created in the properties model.", (Object)pushedInterface1);
        ComponentTypeIntrospectionTests.assertEquals((String)"The correct interface should have been pushed to the properties model.", (String)ORG_ACME_TEST_INTERFACE, (String)pushedInterface1);
        String pushedInterface2 = props.getProperty(PropertiesSharedModel.serviceKey("PushedService2"));
        ComponentTypeIntrospectionTests.assertNotNull((String)"A service should have been created in the properties model.", (Object)pushedInterface2);
        ComponentTypeIntrospectionTests.assertEquals((String)"The correct interface should have been pushed to the properties model.", (String)ORG_ACME_TEST_INTERFACE, (String)pushedInterface2);
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionServices_PullSynchronization() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        int sizeBeforeAddition = componentType.getServices().size();
        PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        PropertiesSharedModel.createNewService(props, "PulledService1", ORG_ACME_TEST_INTERFACE);
        PropertiesSharedModel.createNewService(props, "PulledService2", ORG_ACME_TEST_INTERFACE);
        ComponentTypeIntrospectionTests.assertEquals((String)"The number of services should have increased by exactly two.", (int)(sizeBeforeAddition + 2), (int)componentType.getServices().size());
        Service s1 = componentType.getService("PulledService1");
        ComponentTypeIntrospectionTests.assertNotNull((String)"There should be a service with the name PulledService1", (Object)s1);
        ComponentTypeIntrospectionTests.assertTrue((boolean)(s1.getInterface() instanceof JavaInterface));
        JavaInterface jInterface1 = (JavaInterface)s1.getInterface();
        ComponentTypeIntrospectionTests.assertEquals((String)"The interface should be the expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)jInterface1.getName());
        Service s2 = componentType.getService("PulledService2");
        ComponentTypeIntrospectionTests.assertNotNull((String)"There should be a service with the name PulledService2", (Object)s2);
        ComponentTypeIntrospectionTests.assertTrue((boolean)(s2.getInterface() instanceof JavaInterface));
        JavaInterface jInterface2 = (JavaInterface)s2.getInterface();
        ComponentTypeIntrospectionTests.assertEquals((String)"The interface should be the expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)jInterface2.getName());
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionReferences() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        AssertNotificationAdapter assertAdapter = new AssertNotificationAdapter();
        componentType.getEObject().eAdapters().add((Object)assertAdapter);
        List references = componentType.getReferences();
        assertAdapter.assertNoNotifications("No notifications should be generated when fetching references for the first time.");
        componentType.getEObject().eAdapters().remove((Object)assertAdapter);
        ComponentTypeIntrospectionTests.assertTrue((references.size() > 0 ? 1 : 0) != 0);
        Reference reference = (Reference)references.get(0);
        ComponentTypeIntrospectionTests.assertEquals((String)"The reference name should match the expected value.", (String)EXPECTED_REFERENCE_NAME, (String)reference.getName());
        ComponentTypeIntrospectionTests.assertTrue((String)"The reference should have a Java Interface.", (boolean)(reference.getInterface() instanceof JavaInterface));
        JavaInterface jifze = (JavaInterface)reference.getInterface();
        ComponentTypeIntrospectionTests.assertEquals((String)"The Java interface should be the expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)jifze.getInterface());
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionReferences_PushSynchronization() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        Reference reference1 = this.createReference("PushedReference1");
        Reference reference2 = this.createReference("PushedReference2");
        componentType.getReferences().add(reference1);
        componentType.getReferences().add(reference2);
        PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        String pushedInterface1 = props.getProperty(PropertiesSharedModel.referenceKey("PushedReference1"));
        ComponentTypeIntrospectionTests.assertNotNull((String)"A service should have been created in the properties model.", (Object)pushedInterface1);
        ComponentTypeIntrospectionTests.assertEquals((String)"The correct interface should have been pushed to the properties model.", (String)ORG_ACME_TEST_INTERFACE, (String)pushedInterface1);
        String pushedInterface2 = props.getProperty(PropertiesSharedModel.referenceKey("PushedReference2"));
        ComponentTypeIntrospectionTests.assertNotNull((String)"A service should have been created in the properties model.", (Object)pushedInterface2);
        ComponentTypeIntrospectionTests.assertEquals((String)"The correct interface should have been pushed to the properties model.", (String)ORG_ACME_TEST_INTERFACE, (String)pushedInterface2);
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionReferences_PullSynchronization() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        int sizeBeforeAddition = componentType.getReferences().size();
        PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        PropertiesSharedModel.createNewReference(props, "PulledReference1", ORG_ACME_TEST_INTERFACE);
        PropertiesSharedModel.createNewReference(props, "PulledReference2", ORG_ACME_TEST_INTERFACE);
        ComponentTypeIntrospectionTests.assertEquals((String)"The number of references should have increased by exactly two.", (int)(sizeBeforeAddition + 2), (int)componentType.getReferences().size());
        Reference r1 = componentType.getReference("PulledReference1");
        ComponentTypeIntrospectionTests.assertNotNull((String)"There should be a reference with the name PulledReference1", (Object)r1);
        ComponentTypeIntrospectionTests.assertTrue((boolean)(r1.getInterface() instanceof JavaInterface));
        JavaInterface jInterface1 = (JavaInterface)r1.getInterface();
        ComponentTypeIntrospectionTests.assertEquals((String)"The interface should be the expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)jInterface1.getName());
        Reference r2 = componentType.getReference("PulledReference2");
        ComponentTypeIntrospectionTests.assertNotNull((String)"There should be a service with the name PulledReference2", (Object)r2);
        ComponentTypeIntrospectionTests.assertTrue((boolean)(r2.getInterface() instanceof JavaInterface));
        JavaInterface jInterface2 = (JavaInterface)r2.getInterface();
        ComponentTypeIntrospectionTests.assertEquals((String)"The interface should be the expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)jInterface2.getName());
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionProperties() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        AssertNotificationAdapter assertAdapter = new AssertNotificationAdapter();
        componentType.getEObject().eAdapters().add((Object)assertAdapter);
        List properties = componentType.getProperties();
        assertAdapter.assertNoNotifications("No notifications should be generated when fetching references for the first time.");
        componentType.getEObject().eAdapters().remove((Object)assertAdapter);
        ComponentTypeIntrospectionTests.assertTrue((properties.size() > 0 ? 1 : 0) != 0);
        Property property = (Property)properties.get(0);
        ComponentTypeIntrospectionTests.assertEquals((String)"The reference name should match the expected value.", (String)EXPECTED_PROPERTY_NAME, (String)property.getName());
        ComponentTypeIntrospectionTests.assertEquals((String)"The reference should have the expected isRequired value.", (boolean)false, (boolean)property.isRequired());
        ComponentTypeIntrospectionTests.assertEquals((String)"The reference should have the expected property type value.", (Object)EXPECTED_PROP_TYPE_VALUE, (Object)property.getType());
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionProperties_PushSynchronization() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        Property property1 = this.createProperty("PushedProperty1");
        Property property2 = this.createProperty("PushedProperty2");
        componentType.getProperties().add(property1);
        componentType.getProperties().add(property2);
        PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        String value1 = props.getProperty(PropertiesSharedModel.propertyKey("PushedProperty1"));
        ComponentTypeIntrospectionTests.assertNotNull((String)"A property should have been created in the properties model.", (Object)value1);
        ComponentTypeIntrospectionTests.assertEquals((String)"The correct value should have been pushed to the properties model.", (String)EXPECTED_PROP_TYPE_VALUE, (String)value1);
        String value2 = props.getProperty(PropertiesSharedModel.propertyKey("PushedProperty2"));
        ComponentTypeIntrospectionTests.assertNotNull((String)"A property should have been created in the properties model.", (Object)value2);
        ComponentTypeIntrospectionTests.assertEquals((String)"The correct value should have been pushed to the properties model.", (String)EXPECTED_PROP_TYPE_VALUE, (String)value2);
        scribbler.close(null);
    }

    public void testComponentTypeIntrospectionProperties_PullSynchronization() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        int sizeBeforeAddition = componentType.getProperties().size();
        PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        PropertiesSharedModel.createNewProperty(props, "PulledProperties1", EXPECTED_PROP_TYPE_VALUE);
        PropertiesSharedModel.createNewProperty(props, "PulledProperties2", EXPECTED_PROP_TYPE_VALUE);
        ComponentTypeIntrospectionTests.assertEquals((String)"The number of properties should have increased by exactly two.", (int)(sizeBeforeAddition + 2), (int)componentType.getProperties().size());
        Property r1 = componentType.getProperty("PulledProperties1");
        ComponentTypeIntrospectionTests.assertNotNull((String)"There should be a property with the name PulledProperties1", (Object)r1);
        Property r2 = componentType.getProperty("PulledProperties2");
        ComponentTypeIntrospectionTests.assertNotNull((String)"There should be a service with the name PulledProperties2", (Object)r2);
        scribbler.close(null);
    }

    public void testResolveImplementation() throws Exception {
        CompositeScribblerDomain compositeScribblerDomain = new CompositeScribblerDomain(this.compositeFile);
        IEditModelScribbler scribbler = compositeScribblerDomain.createScribblerForWrite();
        Resource resource = scribbler.getResource(compositeScribblerDomain.getCompositeDescriptor());
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        Composite composite = root.getComposite();
        ComponentTypeIntrospectionTests.assertNotNull((Object)composite);
        Component component = (Component)composite.getComponents().get(0);
        ComponentTypeIntrospectionTests.assertNotNull((Object)component);
        ComponentType componentType = component.resolveComponentType();
        Object implementation = componentType.resolveImplementation();
        ComponentTypeIntrospectionTests.assertTrue((String)("The implementation should be of type " + PropertiesSharedModel.NotifyingProperties.class.getName()), (boolean)(implementation instanceof PropertiesSharedModel.NotifyingProperties));
        PropertiesSharedModel.NotifyingProperties propertiesImplementation = (PropertiesSharedModel.NotifyingProperties)implementation;
        PropertiesSharedModel.NotifyingProperties expectedImplementation = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        ComponentTypeIntrospectionTests.assertEquals((String)"The properties implementation should be the shared model.", (Object)expectedImplementation, (Object)propertiesImplementation);
        scribbler.close(null);
    }

    private Service createService(String name) {
        Service service = this.factory.createService();
        service.setName(name);
        JavaInterface jInterface = this.factory.createJavaInterface();
        jInterface.setInterface(ORG_ACME_TEST_INTERFACE);
        service.setInterface((Interface)jInterface);
        return service;
    }

    private Reference createReference(String name) {
        Reference reference = this.factory.createReference();
        reference.setName(name);
        JavaInterface jInterface = this.factory.createJavaInterface();
        jInterface.setInterface(ORG_ACME_TEST_INTERFACE);
        reference.setInterface((Interface)jInterface);
        return reference;
    }

    private Property createProperty(String name) {
        Property property = this.factory.createProperty();
        property.setName(name);
        property.setDefault(EXPECTED_PROP_TYPE_VALUE);
        return property;
    }
}

