/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.stp.core.infrastructure.assertion.AssertionFailedException;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.SCAFactory;

public class UsagePatternTests
extends TestCase {
    private static final String PROJECT_NAME = "UsagePatternTests";
    private IProject project;

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testAcceptsNullEntryPoint_setInterface() throws Exception {
        try {
            EntryPoint point = SCAFactory.eINSTANCE.createEntryPoint();
            point.setInterface(null);
        }
        catch (RuntimeException runtimeException) {
            UsagePatternTests.assertTrue((String)"Problem when calling EntryPoint.setInterface(null).", (boolean)false);
        }
    }

    public void testAcceptsNullExternalService_setInterface() throws Exception {
        try {
            ExternalService extsvc = SCAFactory.eINSTANCE.createExternalService();
            extsvc.setInterface(null);
        }
        catch (RuntimeException runtimeException) {
            UsagePatternTests.assertTrue((String)"Problem when calling EntryPoint.setInterface(null).", (boolean)false);
        }
    }

    public void testResolveComponentType_UncontainedSpecializedComponent() throws Exception {
        try {
            Component component = SCAFactory.eINSTANCE.createComponent();
            JavaImplementation jImpl = SCAFactory.eINSTANCE.createJavaImplementation();
            jImpl.setClass("test");
            component.setSpecializedImplementation((Implementation)jImpl);
            component.resolveComponentType();
        }
        catch (AssertionFailedException assertionFailedException) {
            return;
        }
        UsagePatternTests.assertTrue((String)"An assertion should be thrown for specialized, uncontained components.", (boolean)false);
    }

    public void testResolveComponentType_UncontainedAbstractComponent() throws Exception {
        try {
            Component component = SCAFactory.eINSTANCE.createComponent();
            ComponentType ctype = SCAFactory.eINSTANCE.createComponentType();
            component.setAbstractImplementation(ctype);
            component.resolveComponentType();
        }
        catch (AssertionFailedException assertionFailedException) {
            UsagePatternTests.assertTrue((String)"An assertion should NOT be thrown for abstract, uncontained components.", (boolean)false);
        }
    }

    public void testEntryPoint_setInterfaceMultipleTimes() throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe method add(EObject) in the type List<EObject> is not applicable for the arguments (SCACoreRoot)\n");
    }

    public void testExternalService_setInterfaceMultipleTimes() throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe method add(EObject) in the type List<EObject> is not applicable for the arguments (SCACoreRoot)\n");
    }
}

