/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.saf;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.tests.introspection.PropertiesSharedModel;
import org.eclipse.stp.core.tests.properties.PropertiesImplementation;
import org.eclipse.stp.core.tests.properties.PropsFactory;
import org.eclipse.stp.core.tests.properties.PropsPackage;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class PropComponentCreationOperation
extends AbstractDataModelOperation {
    public static final String CREATE_IMPL_FOR_FILE_NAME = "CreateImplTest.properties";
    public static final String CREATE_COMP_COMPONENT_NAME = "CreateCompComponent";
    public static final String CREATE_COMP_FOR_COMPONENT_NAME = "CreateCompForComponent";
    private Object result = null;
    private int opType = 0;
    private Object implementationObj = null;
    private Component theComponent;
    private IContainer implFileLocation;
    public static final int CREATE_COMP = 1;
    public static final int CREATE_COMP_FOR = 2;
    public static final int CREATE_IMPL_FOR = 3;
    public static final int SET_IMPL_FOR = 4;
    private static final String ORG_ACME_TEST_INTERFACE = "org.acme.TestInterface";
    private static final String EXPECTED_PROP_TYPE_VALUE = "java.lang.String";
    private static final String EXPECTED_PROPERTY_NAME = "SimpleProperty";
    private static final String EXPECTED_REFERENCE_NAME = "SimpleReference";
    private static final String EXPECTED_SERVICE_NAME = "SimpleService";

    public PropComponentCreationOperation(int opType) {
        this.opType = opType;
    }

    public void setImplObj(Object implementationObj) {
        this.implementationObj = implementationObj;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        switch (this.opType) {
            case 1: {
                Component createdComponent1 = null;
                createdComponent1 = SCAFactory.eINSTANCE.createComponent();
                createdComponent1.setName(CREATE_COMP_COMPONENT_NAME);
                createdComponent1.setAbstractImplementation(SCAFactory.eINSTANCE.createComponentType());
                ((AbstractImplementation)createdComponent1.getImplementation()).setType(ExtendedMetaData.INSTANCE.getName((EStructuralFeature)PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties()));
                this.result = createdComponent1;
                break;
            }
            case 2: {
                Component createdComponent2 = null;
                createdComponent2 = SCAFactory.eINSTANCE.createComponent();
                createdComponent2.setName(CREATE_COMP_FOR_COMPONENT_NAME);
                PropertiesImplementation pImpl = PropsFactory.eINSTANCE.createPropertiesImplementation();
                FeatureAdapter.setFeature((SCAObject)pImpl, (EStructuralFeature)PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties());
                pImpl.setProperties(((IFile)this.implementationObj).getProjectRelativePath().toString());
                createdComponent2.setSpecializedImplementation((Implementation)pImpl);
                this.result = createdComponent2;
                break;
            }
            case 3: {
                try {
                    IFile implFile = ((IProject)this.implFileLocation).getFile(CREATE_IMPL_FOR_FILE_NAME);
                    PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(implFile);
                    PropertiesSharedModel.createNewService(props, EXPECTED_SERVICE_NAME, ORG_ACME_TEST_INTERFACE);
                    PropertiesSharedModel.createNewReference(props, EXPECTED_REFERENCE_NAME, ORG_ACME_TEST_INTERFACE);
                    PropertiesSharedModel.createNewProperty(props, EXPECTED_PROPERTY_NAME, EXPECTED_PROP_TYPE_VALUE);
                    PropertiesSharedModel.saveProperties(props);
                    PropertiesImplementation pImpl2 = PropsFactory.eINSTANCE.createPropertiesImplementation();
                    FeatureAdapter.setFeature((SCAObject)pImpl2, (EStructuralFeature)PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties());
                    pImpl2.setProperties(implFile.getProjectRelativePath().toString());
                    this.theComponent.setSpecializedImplementation((Implementation)pImpl2);
                    this.result = pImpl2;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            }
            case 4: {
                PropertiesImplementation pImpl3 = PropsFactory.eINSTANCE.createPropertiesImplementation();
                FeatureAdapter.setFeature((SCAObject)pImpl3, (EStructuralFeature)PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties());
                pImpl3.setProperties(((IFile)this.implementationObj).getProjectRelativePath().toString());
                this.theComponent.setSpecializedImplementation((Implementation)pImpl3);
                this.result = pImpl3;
                break;
            }
        }
        return OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return super.undo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return super.redo(monitor, info);
    }

    public Object getResult() {
        return this.result;
    }

    public void setComponent(Component theComponent) {
        this.theComponent = theComponent;
    }

    public void setImplFileLocation(IContainer implFileLocation) {
        this.implFileLocation = implFileLocation;
    }
}

