/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.create.operations;

import java.util.Set;
import org.apache.xerces.util.XMLChar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.create.operations.ComponentCreationOperation;
import org.eclipse.stp.core.create.operations.IComponentCreationDataModelProperties;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ComponentCreationDataModelProvider
extends AbstractScribblerDataModelProvider
implements IComponentCreationDataModelProperties {
    public static final String COMPONENT_DEFAULT_NAME = "Component";
    protected static final String URI_RESTRICTED_CHARACTERS = ":?#@!";

    public IDataModelOperation getDefaultOperation() {
        return new ComponentCreationOperation(this.model);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IComponentCreationDataModelProperties.NAME");
        propertyNames.add("IComponentCreationDataModelProperties.COMPOSITE");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IComponentCreationDataModelProperties.NAME")) {
            return this.getDefaultName();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected String getDefaultName() {
        String defaultName = COMPONENT_DEFAULT_NAME;
        Composite composite = (Composite)this.model.getProperty("IComponentCreationDataModelProperties.COMPOSITE");
        int i = 0;
        if (composite != null) {
            while (composite.getComponent(defaultName) != null) {
                defaultName = COMPONENT_DEFAULT_NAME + i;
                ++i;
            }
        }
        return defaultName;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IComponentCreationDataModelProperties.NAME")) {
            return this.validateName();
        }
        if (propertyName.equals("IComponentCreationDataModelProperties.COMPOSITE")) {
            return this.validateComposite();
        }
        return super.validate(propertyName);
    }

    private IStatus validateComposite() {
        IStatus returnStatus = OK_STATUS;
        Composite composite = (Composite)this.getProperty("IComponentCreationDataModelProperties.COMPOSITE");
        if (composite == null) {
            returnStatus = STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText, null);
        }
        if (!returnStatus.isOK()) {
            return returnStatus;
        }
        return returnStatus;
    }

    private IStatus validateName() {
        IStatus returnStatus = OK_STATUS;
        String name = this.getStringProperty("IComponentCreationDataModelProperties.NAME");
        if (name == null || name.length() <= 0) {
            returnStatus = STPCorePlugin.createErrorStatus(Messages.nameBlank_errorText, null);
        }
        if (!returnStatus.isOK()) {
            return returnStatus;
        }
        returnStatus = this.validateNameForValidCharaters(name);
        if (!returnStatus.isOK()) {
            return returnStatus;
        }
        Composite composite = (Composite)this.model.getProperty("IComponentCreationDataModelProperties.COMPOSITE");
        if (composite != null && composite.getComponent(name) != null) {
            returnStatus = STPCorePlugin.createErrorStatus(NLS.bind((String)Messages.nameAlreadyInUse_errorText, (Object)name), null);
        }
        return returnStatus;
    }

    private IStatus validateNameForValidCharaters(String name) {
        if (!XMLChar.isValidNCName((String)name)) {
            return STPCorePlugin.createErrorStatus(Messages.bind((String)Messages.nameNotValid_errorText, (Object)name), null);
        }
        int i = 0;
        while (i < URI_RESTRICTED_CHARACTERS.length()) {
            if (name.indexOf(URI_RESTRICTED_CHARACTERS.charAt(i)) != -1) {
                return STPCorePlugin.createErrorStatus(Messages.bind((String)Messages.portionOfNameNotValid_errorText, (Object)name, (Object)String.valueOf(URI_RESTRICTED_CHARACTERS.charAt(i))), null);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

