/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.edit.operations;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.core.edit.operations.ChangePropertyOperation;
import org.eclipse.stp.core.edit.operations.IChangePropertyDataModelProperties;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ChangePropertyDataModelProvider
extends AbstractScribblerDataModelProvider
implements IChangePropertyDataModelProperties {
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IChangePropertyDataModelProperties.PROPERTY");
        propertyNames.add("IChangePropertyDataModelProperties.NEW_NAME");
        propertyNames.add("IChangePropertyDataModelProperties.NEW_TYPE");
        propertyNames.add("IChangePropertyDataModelProperties.NEW_DEFAULT_VALUE");
        propertyNames.add("IChangePropertyDataModelProperties.NEW_MANY");
        propertyNames.add("IChangePropertyDataModelProperties.NEW_REQUIRED");
        return propertyNames;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IChangePropertyDataModelProperties.PROPERTY")) {
            this.validateProperty();
        } else {
            if (propertyName.equals("IChangePropertyDataModelProperties.NEW_NAME")) {
                return this.validateNewName();
            }
            if (propertyName.equals("IChangePropertyDataModelProperties.NEW_TYPE")) {
                return this.validateNewType();
            }
            if (propertyName.equals("IChangePropertyDataModelProperties.NEW_DEFAULT_VALUE")) {
                return this.validateNewDefaultValue();
            }
        }
        return super.validate(propertyName);
    }

    public IDataModelOperation getDefaultOperation() {
        return new ChangePropertyOperation(this.model);
    }

    private IStatus validateProperty() {
        Object obj = this.model.getProperty("IChangePropertyDataModelProperties.PROPERTY");
        if (obj == null || !(obj instanceof Property)) {
            return STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText, null);
        }
        return OK_STATUS;
    }

    private IStatus validateNewName() {
        String newName = this.getStringProperty("IChangePropertyDataModelProperties.NEW_NAME");
        if (newName == null || newName.length() <= 0) {
            return STPCorePlugin.createErrorStatus(Messages.newNameBlank_errorText, null);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateNewDefaultValue() {
        return Status.OK_STATUS;
    }

    private IStatus validateNewType() {
        return Status.OK_STATUS;
    }
}

