/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.introspection.query;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.introspection.query.CombinedQuery;
import org.eclipse.stp.core.internal.introspection.query.IModelQuery;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.SCAObject;

public class StructuralFeatureExpression
extends CombinedQuery
implements IModelQuery {
    private EStructuralFeature expectedSubstitutionGroupFeature;
    private EClass expectedType;
    private EStructuralFeature expectedFeature;

    public StructuralFeatureExpression(EStructuralFeature theExpectedFeature, EClass theExpectedType, EStructuralFeature theSubstitutionGroupFeature, int theChangeType) {
        super(theChangeType);
        Assert.isTrue((!FeatureMapUtil.isFeatureMap((EStructuralFeature)theExpectedFeature) ? 1 : 0) != 0);
        this.expectedFeature = theExpectedFeature;
        this.expectedType = theExpectedType;
        this.expectedSubstitutionGroupFeature = theSubstitutionGroupFeature;
    }

    public boolean matches(EObject anObject) {
        if (this.expectedFeature.isMany()) {
            List elements = (List)anObject.eGet(this.expectedFeature);
            int i = 0;
            while (i < elements.size()) {
                EObject eChild = (EObject)elements.get(i);
                if (eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                    return true;
                }
                ++i;
            }
        } else {
            EObject eChild = (EObject)anObject.eGet(this.expectedFeature);
            if (eChild != null && eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                return true;
            }
        }
        return false;
    }

    public boolean applyDelta(EObject anObject) {
        switch (this.getType()) {
            case 1: {
                if (this.expectedFeature.isMany()) {
                    List elements = (List)anObject.eGet(this.expectedFeature);
                    int i = 0;
                    while (i < elements.size()) {
                        EObject eChild = (EObject)elements.get(i);
                        if (eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                            if (this.applyChildrenDelta(eChild)) {
                                List untouchedElements = this.getParentUntouchedElements(anObject, this.expectedFeature);
                                untouchedElements.remove(eChild);
                                return true;
                            }
                            return false;
                        }
                        ++i;
                    }
                    EObject eChild = this.createType();
                    if (this.applyChildrenDelta(eChild)) {
                        elements.add(eChild);
                        return true;
                    }
                    return false;
                }
                EObject eChild = (EObject)anObject.eGet(this.expectedFeature);
                if (eChild != null && eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                    if (this.applyChildrenDelta(eChild)) {
                        List untouchedElements = this.getParentUntouchedElements(anObject, this.expectedFeature);
                        untouchedElements.remove(eChild);
                        return true;
                    }
                    return false;
                }
                eChild = this.createType();
                if (this.applyChildrenDelta(eChild)) {
                    anObject.eSet(this.expectedFeature, (Object)eChild);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.expectedFeature.isMany()) {
                    List elements = (List)anObject.eGet(this.expectedFeature);
                    EObject eChild = this.createType();
                    if (this.applyChildrenDelta(eChild)) {
                        elements.add(eChild);
                        return true;
                    }
                    return false;
                }
                EObject eChild = (EObject)anObject.eGet(this.expectedFeature);
                eChild = this.createType();
                if (this.applyChildrenDelta(eChild)) {
                    anObject.eSet(this.expectedFeature, (Object)eChild);
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.expectedFeature.isMany()) {
                    List elements = (List)anObject.eGet(this.expectedFeature);
                    int i = 0;
                    while (i < elements.size()) {
                        EObject eChild = (EObject)elements.get(i);
                        if (eChild != null && eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                            return this.applyChildrenDelta(eChild);
                        }
                        ++i;
                    }
                    return false;
                }
                EObject eChild = (EObject)anObject.eGet(this.expectedFeature);
                if (eChild != null && eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                    return this.applyChildrenDelta(eChild);
                }
                return false;
            }
            case 8: {
                if (this.expectedFeature.isMany()) {
                    List elements = (List)anObject.eGet(this.expectedFeature);
                    int i = 0;
                    while (i < elements.size()) {
                        EObject eChild = (EObject)elements.get(i);
                        if (eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                            EcoreUtil.remove((EObject)eChild);
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                EObject eChild = (EObject)anObject.eGet(this.expectedFeature);
                if (eChild != null && eChild.eClass().equals(this.expectedType) && this.matchesChildren(eChild)) {
                    EcoreUtil.remove((EObject)eChild);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private EObject createType() {
        EFactory eFactory = this.expectedType.getEPackage().getEFactoryInstance();
        EObject eChild = eFactory.create(this.expectedType);
        if (this.expectedSubstitutionGroupFeature != null) {
            FeatureAdapter.setFeature((SCAObject)eChild, this.expectedSubstitutionGroupFeature);
        }
        return eChild;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(" has feature ").append(this.expectedFeature.getName()).append(" of type ").append(this.expectedType.getName());
        return toString.append("\n[").append(super.toString()).append("]").toString();
    }
}

