/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WireTarget;

public class ReferenceValueImpl
extends SCAInternalObjectImpl
implements ReferenceValue {
    public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved.";
    protected static final String TARGET_URI_EDEFAULT = null;
    protected String targetURI = TARGET_URI_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected FeatureMap anyAttribute = null;
    private Reference resolvedReference;
    private boolean hasResolvedReference;
    private boolean hasParsedTargetURI;
    private WireTarget resolvedWireTarget;

    protected ReferenceValueImpl() {
    }

    protected EClass eStaticClass() {
        return SCAPackage.eINSTANCE.getReferenceValue();
    }

    public String getTargetURI() {
        if (this.resolvedWireTarget != null) {
            return this.resolvedWireTarget.getName();
        }
        return this.getTargetURIGen();
    }

    public String getTargetURIGen() {
        return this.targetURI;
    }

    public void setTargetURI(String newTargetURI) {
        if (newTargetURI != this.targetURI && (newTargetURI != null && !newTargetURI.equals(this.targetURI) || this.targetURI != null && !this.targetURI.equals(newTargetURI))) {
            this.resolvedWireTarget = null;
            this.hasParsedTargetURI = false;
        }
        this.setTargetURIGen(newTargetURI);
    }

    public void setTargetURIGen(String newTargetURI) {
        String oldTargetURI = this.targetURI;
        this.targetURI = newTargetURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldTargetURI, (Object)this.targetURI));
        }
    }

    public String getName() {
        if (this.hasResolvedReference && this.resolvedReference != null) {
            return this.resolvedReference.getName();
        }
        return this.getNameGen();
    }

    public String getNameGen() {
        return this.name;
    }

    public void setNameGen(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    public void setName(String newName) {
        if (newName != this.name && (newName != null && !newName.equals(this.name) || this.name != null && !this.name.equals(newName))) {
            this.resolvedReference = null;
        }
        this.setNameGen(newName);
    }

    public FeatureMap getAnyAttribute() {
        if (this.anyAttribute == null) {
            this.anyAttribute = new BasicFeatureMap((InternalEObject)this, 2);
        }
        return this.anyAttribute;
    }

    public ReferenceValuesSet getReferenceValueSet() {
        if (this.eContainerFeatureID != 3) {
            return null;
        }
        return (ReferenceValuesSet)this.eContainer;
    }

    public void setReferenceValueSet(ReferenceValuesSet newReferenceValueSet) {
        if (newReferenceValueSet != this.eContainer || this.eContainerFeatureID != 3 && newReferenceValueSet != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)((EObject)newReferenceValueSet))) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newReferenceValueSet != null) {
                msgs = ((InternalEObject)newReferenceValueSet).eInverseAdd((InternalEObject)this, 0, ReferenceValuesSet.class, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)newReferenceValueSet, 3, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newReferenceValueSet, (Object)newReferenceValueSet));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 3, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 2: {
                    return ((InternalEList)this.getAnyAttribute()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return this.eBasicSetContainer(null, 3, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 3: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 0, ReferenceValuesSet.class, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getTargetURI();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getAnyAttribute();
            }
            case 3: {
                return this.getReferenceValueSet();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setTargetURI((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.getAnyAttribute().clear();
                this.getAnyAttribute().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setReferenceValueSet((ReferenceValuesSet)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.getAnyAttribute().clear();
                return;
            }
            case 3: {
                this.setReferenceValueSet(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals(this.targetURI);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.anyAttribute != null && !this.anyAttribute.isEmpty();
            }
            case 3: {
                return this.getReferenceValueSet() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (targetURI: ");
        result.append(this.targetURI);
        result.append(", name: ");
        result.append(this.name);
        result.append(", anyAttribute: ");
        result.append(this.anyAttribute);
        result.append(')');
        return result.toString();
    }

    public void setTarget(WireTarget wireTarget) {
        this.resolvedWireTarget = wireTarget;
        if (wireTarget != null && this.targetURI == null) {
            this.setTargetURIGen(wireTarget.getName());
        }
    }

    public Reference getReference() {
        if (!this.hasResolvedReference) {
            this.hasResolvedReference = true;
            this.resolvedReference = this.resolveReferenceFromName();
        }
        return this.resolvedReference;
    }

    private Reference resolveReferenceFromName() {
        ComponentType type;
        Component component;
        if (this.getNameGen() != null && (component = this.getOwningComponent()) != null && (type = component.resolveComponentType()) != null) {
            return type.getReference(this.getNameGen());
        }
        return null;
    }

    public void setReference(Reference reference) {
        Assert.isNotNull((Object)reference);
        this.hasResolvedReference = true;
        this.resolvedReference = reference;
        if (!this.eIsSet((EStructuralFeature)SCAPackage.eINSTANCE.getReferenceValue_Name())) {
            this.setNameGen(reference.getName());
        }
    }

    public WireTarget getTarget() {
        if (!this.hasParsedTargetURI) {
            this.parseTargetURI();
        }
        return this.resolvedWireTarget;
    }

    public Component getOwningComponent() {
        ReferenceValuesSet set = this.getReferenceValueSet();
        return set == null ? null : set.getComponent();
    }

    private void parseTargetURI() {
        Composite composite;
        if (!this.hasParsedTargetURI && (composite = this.getComposite()) != null) {
            this.hasParsedTargetURI = true;
            this.resolvedWireTarget = composite.resolveWireTarget(this.getTargetURI());
        }
    }

    private Composite getComposite() {
        Component component = this.getOwningComponent();
        return component != null ? component.getComposite() : null;
    }

    public boolean targets(WireTarget wireTarget) {
        if (wireTarget != null) {
            if (wireTarget.equals(this.resolvedWireTarget)) {
                return true;
            }
            return wireTarget.getName() != null && wireTarget.getName().equals(this.getTargetURI());
        }
        return false;
    }
}

