/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.stp.sc.common.utils.JDTUtils;

public class JDTUtilsTest
extends TestCase {
    private static final String PROJECT_NAME = "JDTUtilsTestProj";
    IProject project;

    protected void setUp() throws Exception {
        super.setUp();
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!newProject.exists()) {
            this.project = this.createJavaProject(PROJECT_NAME);
        } else {
            this.project.open(null);
        }
    }

    private IProject createJavaProject(String projectName) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject theProject = root.getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(theProject.getName());
        theProject.create(description, null);
        theProject.open(null);
        theProject.setDescription(description, null);
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
        description.setNatureIds(newNatures);
        theProject.setDescription(description, 1, null);
        IJavaProject javaProj = JavaCore.create((IProject)theProject);
        IClasspathEntry jreEntry = JavaRuntime.getDefaultJREContainerEntry();
        IFolder srcFolder = theProject.getFolder("src");
        if (!srcFolder.exists()) {
            srcFolder.create(false, true, null);
        }
        IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        IClasspathEntry[] newEntries = new IClasspathEntry[]{jreEntry, srcEntry};
        javaProj.setRawClasspath(newEntries, null);
        javaProj.save(null, true);
        return theProject;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.delete(true, null);
    }

    public void testGetJavaProjectByName() throws Exception {
        IJavaProject javaProj = JDTUtils.getJavaProjectByName((String)PROJECT_NAME);
        JDTUtilsTest.assertNotNull((String)"should get java project", (Object)javaProj);
    }
}

