/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class CreateActionBase
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    protected IStructuredSelection selection;
    static final String JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    private static LoggingProxy LOG = LoggingProxy.getlogger(CreateActionBase.class);

    public void init(IWorkbenchWindow window) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection sel) {
        LOG.debug((Object)("selection: " + sel));
        if (sel == null) {
            this.selection = null;
        } else if (sel instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)sel;
        }
    }

    protected boolean isJavaEditorOpen(IResource javaResource) {
        if (javaResource == null) {
            return false;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int editorCount = activePage.findEditors((IEditorInput)new FileEditorInput((IFile)javaResource), JAVA_EDITOR_ID, 3).length;
        return editorCount > 0;
    }

    protected void openJavaEditor(IResource javaResource) throws PartInitException {
        if (javaResource == null) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.openEditor((IEditorInput)new FileEditorInput((IFile)javaResource), JAVA_EDITOR_ID, true);
    }
}

