/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.generators;

import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.cxf.CXFProjectBaseTest;
import org.eclipse.stp.sc.cxf.TestUtilities;
import org.eclipse.stp.sc.cxf.generators.CeltixWsdlToJavaGenerator;
import org.eclipse.stp.sc.cxf.generators.CeltixWsdlToJavaParameterPage;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CeltixWsdlToJavaGeneratorTest
extends CXFProjectBaseTest {
    public static final String PROJECT_NAME = "JavaToWsdlGeneratorTestProject";
    CeltixWsdlToJavaParameterPage w2jParameterPage;
    CeltixWsdlToJavaGenerator w2jGenerator;
    String wsdlURL;
    protected String[] projectFiles = new String[]{"/wsdl/DemoGreeterRPCLit.wsdl"};
    protected String[] resourceFiles = new String[]{"/resources/DemoGreeterRPCLit.wsdl_resource"};

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    protected void setUp() throws Exception {
        super.setUp();
        IFolder srcFolder = this.project.getFolder("src");
        srcFolder.create(true, true, null);
        TestUtilities.setWorkspaceAutoBuild(false);
        this.w2jParameterPage = new CeltixWsdlToJavaParameterPage();
        this.w2jParameterPage.createContents((Composite)Display.getDefault().getActiveShell());
        this.w2jGenerator = new CeltixWsdlToJavaGenerator();
        this.wsdlURL = this.files[0].getRawLocation().toOSString();
        Hashtable<String, Object> genParams = new Hashtable<String, Object>();
        genParams.put("TOOL_SPECIFIC_OPS", this.w2jParameterPage.getParameters());
        String srcDir = JaxWsWorkspaceManager.getSrcFolder((IProject)this.project).getLocation().toOSString();
        genParams.put("GEN_OUTPUTDIR", srcDir);
        this.w2jGenerator.setInitializationData(null, null, genParams);
        this.w2jGenerator.run(this.wsdlURL, this.project);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TestUtilities.setWorkspaceAutoBuild(true);
    }

    public void testWsdlToJava() throws Exception {
        IFile seiFile = this.project.getFolder("src").getFile("/demo/GreeterRPCLit.java");
        CeltixWsdlToJavaGeneratorTest.assertTrue((String)"sei should be generated.", (boolean)seiFile.exists());
        IFile clientFile = this.project.getFolder("src").getFile("/demo/GreeterRPCLitClient.java");
        CeltixWsdlToJavaGeneratorTest.assertTrue((String)"client should be generated.", (boolean)clientFile.exists());
        IFile serverFile = this.project.getFolder("src").getFile("/demo/GreeterRPCLitServer.java");
        CeltixWsdlToJavaGeneratorTest.assertTrue((String)"server should be generated.", (boolean)serverFile.exists());
        IFile serviceFile = this.project.getFolder("src").getFile("/demo/GreeterRPCLitService.java");
        CeltixWsdlToJavaGeneratorTest.assertTrue((String)"service should be generated.", (boolean)serviceFile.exists());
        IFile implFile = this.project.getFolder("src").getFile("/demo/GreeterRPCLitImpl.java");
        CeltixWsdlToJavaGeneratorTest.assertTrue((String)"impl should be generated.", (boolean)implFile.exists());
    }
}

