/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder;

import org.eclipse.stp.sc.xmlvalidator.classbuilder.inst.JInstruction;

/**
 * @author jma
 * factory class to generate code step(s). 
 */
public class JCodeFactory {

	/**
	 * point to the constance pool in the class
	 */
	JConstantPool pool = null;
    public JCodeFactory(JConstantPool thePool) {
    	pool = thePool;
    }

    
    public JCodeStep createCodeStep(JInstruction opCode) {
        return new JCodeStep(opCode);
    }
    
    //invokevirtual
    public JCodeStep createInvokeVtl(String className, JMethod method) {
    	
        int index = pool.methodConstant(className, method);
        return new JCodeStep(JInstruction.INVOKEVIRTUAL, new Short((short)index));
        
    }

    
    public JCodeStep createInvoke(String className, JMethod method) {
    	
    	int index = pool.methodConstant(className, method);
        return new JCodeStep(JInstruction.INVOKESPECIAL, new Short((short)index));
    }
    

    public JCodeStep createLoadConst(String constStr) {
    	
        int index = pool.stringConstant(constStr);
        return new JCodeStep(JInstruction.LDC, new Byte((byte)index));
        
    }

    public JCodeStep createGetStaticField(String className, JField field) {
    	
    	int index = pool.fieldConstant(className, field);
    	return new JCodeStep(JInstruction.GETSTATIC, new Short((short)index));
    	
    }

    public JCodeStep createLoadThis() {
        return new JCodeStep(JInstruction.ALOAD_, 0);
    }
    
    public JCodeStep[] createNew(String className) {
    	JCodeStep[] steps = new JCodeStep[4];
    	int index = pool.classConstant(className);
    	steps[0] = new JCodeStep(JInstruction.NEW, new Short((short)index));
    	steps[1] = new JCodeStep(JInstruction.DUP);
    	JMethod initMethod = new JMethod("<init>");
    	steps[2] = createInvoke(className, initMethod);
    	steps[3] = new JCodeStep(JInstruction.ASTORE_, 1);
    	return steps;
    }
    
    public JCodeStep createALoad(int index) {
    	return new JCodeStep(JInstruction.ALOAD_, index);
    }
    
    
}
