/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.annotations;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class ScAnnotationSupportUtilsTest
extends TestCase {
    public static final String JAVA_PROJECT_NAME = "ScAnnotationSupportTest_JAVA";
    public static final String JAXWS_PROJECT_NAME = "ScAnnotationSupportTest_JAXWS";
    IProject javaProject;
    IProject jaxwsProject;

    protected void setUp() throws Exception {
        super.setUp();
        this.jaxwsProject = ResourcesPlugin.getWorkspace().getRoot().getProject(JAXWS_PROJECT_NAME);
        if (!this.jaxwsProject.exists()) {
            this.jaxwsProject = this.createJaxWsProject();
        } else {
            try {
                this.jaxwsProject.open(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.javaProject = TestUtilities.createTestCeltixProject((String)JAVA_PROJECT_NAME);
    }

    protected void tearDown() throws Exception {
        this.javaProject.delete(true, null);
        this.jaxwsProject.delete(true, null);
        super.tearDown();
    }

    private IProject createJaxWsProject() {
        IProject newProject = JaxWsWorkspaceManager.createProject(null, (String)JAXWS_PROJECT_NAME, (IPath)Platform.getLocation(), (String)"JavaFrist");
        return newProject;
    }

    public void testAnnotationForTypes() throws Exception {
        List annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForClass((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return 10 class annotaions for jax-ws project", (annoList.size() == 10 ? 1 : 0) != 0);
        annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForInterface((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return 6 interface annotaions for jax-ws project", (annoList.size() == 6 ? 1 : 0) != 0);
    }

    public void testJavaAnnotationNature() throws Exception {
        List annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForClass((IProject)this.javaProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return no class annotation for java project", (annoList.size() == 0 ? 1 : 0) != 0);
        annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForInterface((IProject)this.javaProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return no interface annotation for java project", (annoList.size() == 0 ? 1 : 0) != 0);
    }

    public void testJaxWsAnnotationNature() throws Exception {
        List annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForClass((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return 10 class annotaions for jax-ws project", (annoList.size() == 10 ? 1 : 0) != 0);
        annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForInterface((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return 6 interface annotaions for jax-ws project", (annoList.size() == 6 ? 1 : 0) != 0);
    }
}

