/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.validator;

import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sc.common.validator.XMLSchemaValidator;

public class XMLSchemaValidatorTest
extends TestCase {
    XMLSchemaValidator validator = null;
    String test_valid_file_path = "/src/resources/xml/Valid_WebService.xml";
    String test_invalid_file_path = "/src/resources/xml/Invalid_WebService.xml";
    String test_schema_file_path = "/src/resources/xml/javax_jws.xsd";
    String test_soapschema_file_path = "/src/resources/xml/javax_jws_soap.xsd";
    String test_valid_soapfile_path = "/src/resources/xml/valid_soapbinding.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new XMLSchemaValidator();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidateXML() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.jaxws.test").getEntry("/");
        URL fileURL = new URL(baseURL, this.test_valid_file_path);
        URL schemaURL = new URL(baseURL, this.test_schema_file_path);
        boolean ret = this.validator.validateXML(fileURL.openStream(), schemaURL.openStream());
        XMLSchemaValidatorTest.assertTrue((String)"it is valid xml.", (boolean)ret);
    }

    public void testInvalidXML_javaID() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.jaxws.test").getEntry("/");
        URL fileURL = new URL(baseURL, this.test_invalid_file_path);
        URL schemaURL = new URL(baseURL, this.test_schema_file_path);
        boolean ret = this.validator.validateXML(fileURL.openStream(), schemaURL.openStream());
        XMLSchemaValidatorTest.assertFalse((String)"invalid xml.", (boolean)ret);
        String msg = this.validator.getErrorMessage();
        String msgToCompare = "The value '111Wrong' of element 'serviceName' is not valid.";
        XMLSchemaValidatorTest.assertTrue((String)"should return error msg.", (boolean)msg.equals(msgToCompare));
    }

    public void testValidSoapBinding() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.jaxws.test").getEntry("/");
        URL fileURL = new URL(baseURL, this.test_valid_soapfile_path);
        URL schemaURL = new URL(baseURL, this.test_soapschema_file_path);
        boolean ret = this.validator.validateXML(fileURL.openStream(), schemaURL.openStream());
        XMLSchemaValidatorTest.assertTrue((String)"valid xml.", (boolean)ret);
    }
}

