/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod;

import java.lang.reflect.InvocationTargetException;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.WebServiceProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AnnotationAttributePage;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class CreateWebMethodWizardForDefaultPackageTest
extends TestCase {
    private static final String TEST_PROJECT_NAME = "CreateWebMethodWizardForDefaultPackageTestProject";
    private static final String LOCAL_JAVA = "src/HelloWorld.java";
    private static final String JAVA_RESOURCE = "HelloWorld_in_default_package.java_resource";
    private IProject testProject = null;
    private IJavaElement javaFile;
    private IMember methodMember;
    private CreateWebMethodWizard wizard;
    private WizardDialog dialog;
    private AnnotationAttributePage methodAttributePage;
    private AnnotationAttributePage resultAttributePage;
    private AnnotationAttributePage requestWrapperAttributePage;
    private AnnotationAttributePage responseWrapperAttributePage;
    private IPreferenceStore preference_store;
    private String originalPrefFlag;

    protected void setUp() throws Exception {
        this.testProject = this.createJavaFirstProject(TEST_PROJECT_NAME);
        this.preference_store = ScJaxWsPlugin.getDefault().getPreferenceStore();
        this.originalPrefFlag = this.preference_store.getString("annWizEnabled");
        this.preference_store.setValue("annWizEnabled", "enabled");
    }

    protected void tearDown() throws Exception {
        this.preference_store.setValue("annWizEnabled", this.originalPrefFlag);
        if (this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
    }

    public void testDefaultPackageName() throws Exception {
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.testProject);
        CreateWebMethodWizardForDefaultPackageTest.assertTrue((String)"project should  exist.", (boolean)this.testProject.exists());
        CreateWebMethodWizardForDefaultPackageTest.assertTrue((String)"should have jax-ws nature", (boolean)this.testProject.hasNature("org.eclipse.stp.sc.jaxws.nature"));
        String mode = this.testProject.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)mode);
        CreateWebMethodWizardForDefaultPackageTest.assertTrue((String)"should set to java first mode.", (boolean)mode.equals("JavaFrist"));
        IFolder srcFolder = this.testProject.getFolder("src");
        CreateWebMethodWizardForDefaultPackageTest.assertTrue((boolean)srcFolder.exists());
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)"/resources/HelloWorld_in_default_package.java_resource");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TestUtilities.openEditor((IWorkbenchWindow)window, (IFile)testFile);
        this.javaFile = JavaCore.create((IFile)testFile);
        CreateWebMethodWizardForDefaultPackageTest.assertTrue((boolean)(this.javaFile instanceof ICompilationUnit));
        IType[] types = ((ICompilationUnit)this.javaFile).getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i] instanceof IMember) {
                this.methodMember = types[i].getMethod("sayHello", new String[0]);
                break;
            }
            ++i;
        }
        CreateWebMethodWizardForDefaultPackageTest.assertEquals((String)"should be sayHello", (String)"sayHello", (String)this.methodMember.getElementName());
        this.openMethodWizard(this.methodMember);
        CreateWebMethodWizardForDefaultPackageTest.assertEquals((int)4, (int)this.wizard.getPageCount());
        this.setupPages();
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.methodAttributePage);
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.resultAttributePage);
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.requestWrapperAttributePage);
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.responseWrapperAttributePage);
        Composite composite = (Composite)this.requestWrapperAttributePage.getControl();
        Text txtClassName = SWTUtils.getTextInCompositeByLabel((Composite)composite, (String)"className");
        CreateWebMethodWizardForDefaultPackageTest.assertEquals((String)"should be default_package", (String)"default_package.SayHello", (String)txtClassName.getText());
        composite = (Composite)this.responseWrapperAttributePage.getControl();
        txtClassName = SWTUtils.getTextInCompositeByLabel((Composite)composite, (String)"className");
        CreateWebMethodWizardForDefaultPackageTest.assertEquals((String)"should be default_package", (String)"default_package.SayHelloResponse", (String)txtClassName.getText());
        this.closeMethodWizard();
    }

    private IProject createJavaFirstProject(String projectName) {
        MyWebServiceProjectWizard wizard = new MyWebServiceProjectWizard();
        wizard.addPages();
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardNewProjectCreationPage genPage = (WizardNewProjectCreationPage)wizard.getPage("generalPage");
        genPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        try {
            wizard.publicCreateProject();
        }
        catch (Exception e) {
            e.printStackTrace();
            CreateWebMethodWizardForDefaultPackageTest.fail((String)e.getMessage());
        }
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        return proj;
    }

    private void openMethodWizard(IMember member) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.wizard = new CreateWebMethodWizard(member);
        this.dialog = new ScWizardDialog(window.getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }

    private void closeMethodWizard() throws Exception {
        this.dialog.close();
        this.methodAttributePage = null;
        this.resultAttributePage = null;
        this.requestWrapperAttributePage = null;
        this.responseWrapperAttributePage = null;
        this.wizard = null;
    }

    private void setupPages() throws Exception {
        String name = AnnotationAttributePage.generatePageName(WebMethod.class);
        this.methodAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(WebResult.class);
        this.resultAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(RequestWrapper.class);
        this.requestWrapperAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(ResponseWrapper.class);
        this.responseWrapperAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
    }

    class MyWebServiceProjectWizard
    extends WebServiceProjectWizard {
        MyWebServiceProjectWizard() {
        }

        public boolean publicCreateProject() throws InvocationTargetException {
            return super.createProject(null);
        }
    }
}

