/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.builders;

import java.util.List;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.RequestWrapper;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;

public class JavaDocumentUtils {
    public static boolean needToGenerateWrapper(ICompilationUnit compUnit) {
        if (compUnit == null) {
            return false;
        }
        List annotations = JDTUtils.getAnnotations((IMember)compUnit.findPrimaryType());
        if (annotations == null) {
            return false;
        }
        boolean rpcStyle = false;
        boolean literalUse = false;
        boolean isBare = false;
        for (Annotation an : annotations) {
            if (!an.getTypeName().getFullyQualifiedName().equals(SOAPBinding.class.getSimpleName())) continue;
            NormalAnnotation normal = (NormalAnnotation)an;
            List members = normal.values();
            for (MemberValuePair member : members) {
                if (member.getName().getFullyQualifiedName().equals("use") && member.getValue().toString().toUpperCase().indexOf("LITERAL") >= 0) {
                    literalUse = true;
                }
                if (member.getName().getFullyQualifiedName().equals("style") && member.getValue().toString().toUpperCase().indexOf("RPC") >= 0) {
                    rpcStyle = true;
                }
                if (!member.getName().getFullyQualifiedName().equals("parameterStyle") || member.getValue().toString().toUpperCase().indexOf("BARE") < 0) continue;
                isBare = true;
            }
            if (rpcStyle && literalUse) {
                return false;
            }
            if (!isBare) continue;
            return false;
        }
        return true;
    }

    public static boolean hasWebServiceAnnotation(IFile javaFile) {
        return JDTUtils.hasAnnotationOnPrimaryType((IFile)javaFile, WebService.class);
    }

    public static boolean hasWrapperAnnotation(ICompilationUnit compUnit) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = compUnit.findPrimaryType().getMethods();
        int n = 0;
        int n2 = iMethodArray.length;
        while (n < n2) {
            IMethod method = iMethodArray[n];
            List annotations = JDTUtils.getAnnotations((IMember)method);
            for (Annotation an : annotations) {
                if (!an.getTypeName().getFullyQualifiedName().equals(RequestWrapper.class.getSimpleName())) continue;
                ScAnnotationSupportUtils.LOG.debug((Object)("find RequestWrapper method, need to generate wrapper classes for :" + compUnit.getUnderlyingResource().getRawLocation().toOSString()));
                return true;
            }
            ++n;
        }
        return false;
    }
}

