/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jmerge.JMerger;
import org.eclipse.stp.common.logging.LoggingProxy;

public class MergeUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(MergeUtils.class);
    private PrintStream oldStdOutStream = System.out;
    private PrintStream oldStdErrStream = System.err;
    static String MERGE_XML_PATH = "/src/org/eclipse/stp/sc/jaxws/utils/merge.xml";

    public static void mergeJavaFile(String sourceFile, String targetFile, String resultFile) throws Exception {
        PrintStream oldStdOutStream = System.out;
        PrintStream oldStdErrStream = System.err;
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.jaxws").getEntry("/");
        URL resourceXML = new URL(baseURL, MERGE_XML_PATH);
        PrintStream newStdOutStream = new PrintStream(new ByteArrayOutputStream());
        PrintStream newStdErrStream = new PrintStream(new ByteArrayOutputStream());
        FileOutputStream targetFileOS = null;
        try {
            try {
                String mergeXMLPath = resourceXML.toString();
                JMerger merger = new JMerger();
                System.setOut(newStdOutStream);
                System.setErr(newStdErrStream);
                String output = merger.execute((IProgressMonitor)new NullProgressMonitor(), new String[]{mergeXMLPath, sourceFile, targetFile});
                targetFileOS = new FileOutputStream(resultFile);
                FileChannel targetFileChannel = targetFileOS.getChannel();
                byte[] targetFileContent = output.getBytes();
                ByteBuffer targetFileBuffer = ByteBuffer.allocate(targetFileContent.length);
                targetFileBuffer.put(targetFileContent);
                targetFileBuffer.flip();
                targetFileChannel.write(targetFileBuffer);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                LOG.debug((Object)(String.valueOf(newStdOutStream.toString()) + newStdErrStream.toString()));
                System.setOut(oldStdOutStream);
                System.setErr(oldStdErrStream);
                targetFileOS.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

